/*
 * Decompiled with CFR 0.152.
 */
package kb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kb.ClipboardItem;
import kb.FileNameGenerator;
import kb.ImageClipboardItem;
import kb.ItemGroup;
import kb.NamedGroupsPersistor;
import kb.NamedItemGroup;
import kb.PreferencesPersistor;
import kb.UserException;
import kb.gui.prefs.MyPreferences;
import kb.utils.Observable;

public class ItemGroupHolder {
    private static final ItemGroupHolder INSTANCE = new ItemGroupHolder();
    private ItemGroup clipboardHistory;
    private List<NamedItemGroup> groups;
    private NamedGroupsPersistor persistor = new NamedGroupsPersistor();
    private Observable<List<NamedItemGroup>> changeObservable = new Observable();
    private Observable<NamedItemGroup> groupCreationObservable = new Observable();

    private ItemGroupHolder() {
        this.clipboardHistory = new ItemGroup("history/dataholder.hstr");
        this.clipboardHistory.setMaxGroupSize(MyPreferences.INSTANCE.getMaxHistorySize());
        this.groups = this.persistor.readFromDisk("history/descriptors.hstr");
        this.initUsedFileNames();
    }

    private void initUsedFileNames() {
        this.initClipboardHistoryUsedFileNames();
        this.initGroupItemsUsedFileNames();
        this.initGroupsUsedFileNames();
    }

    private void initClipboardHistoryUsedFileNames() {
        this.addItemsUsedFileNames(this.clipboardHistory.getItems());
    }

    private void addItemsUsedFileNames(List<ClipboardItem> items) {
        for (ClipboardItem clipboardItem : items) {
            if (clipboardItem.getFileName() == null) continue;
            FileNameGenerator.addToReservedNames(clipboardItem.getFileName());
            if (!(clipboardItem instanceof ImageClipboardItem)) continue;
            FileNameGenerator.addToReservedNames(((ImageClipboardItem)clipboardItem).getPreviewFileName());
        }
    }

    private void initGroupItemsUsedFileNames() {
        for (NamedItemGroup group : this.groups) {
            this.addItemsUsedFileNames(group.getItemGroup().getItems());
        }
    }

    private void initGroupsUsedFileNames() {
        for (NamedItemGroup group : this.groups) {
            FileNameGenerator.addToReservedNames(group.getItemGroup().getFileName());
        }
    }

    public Observable<List<NamedItemGroup>> getChangeObservable() {
        return this.changeObservable;
    }

    public Observable<NamedItemGroup> getGroupCreationObservable() {
        return this.groupCreationObservable;
    }

    public static final ItemGroupHolder getInstance() {
        return INSTANCE;
    }

    public ItemGroup getClipboardHistory() {
        return this.clipboardHistory;
    }

    public List<NamedItemGroup> getItemGroups() {
        return new ArrayList<NamedItemGroup>(this.groups);
    }

    public void addNewItemGroup(String name) throws UserException {
        this.checkItemGroupExists(name);
        NamedItemGroup group = new NamedItemGroup(name, FileNameGenerator.generate("history/", "igrp"));
        this.groups.add(0, group);
        this.storeToDisk();
        this.groupCreationObservable.updateObservers(group);
    }

    private void storeToDisk() {
        this.persistor.storeToDisc(this.groups, "history/descriptors.hstr");
    }

    private void checkItemGroupExists(String name) throws UserException {
        for (NamedItemGroup group : this.groups) {
            if (!group.getName().equals(name)) continue;
            throw new UserException("Group '" + name + "' already exists.");
        }
    }

    public void renameItemGroup(String oldName, String newName) throws UserException {
        this.checkItemGroupExists(newName);
        this.replaceItemGroup(oldName, newName);
        this.storeToDisk();
        this.changeObservable.updateObservers(this.getItemGroups());
    }

    private void replaceItemGroup(String oldName, String newName) {
        int i = 0;
        while (i < this.groups.size()) {
            NamedItemGroup oldGroup = this.groups.get(i);
            if (oldGroup.getName().equals(oldName)) {
                NamedItemGroup newGroup = new NamedItemGroup(newName, oldGroup.getItemGroup());
                this.groups.set(i, newGroup);
                break;
            }
            ++i;
        }
    }

    public void deleteItemGroup(String name) {
        this.doDeleteItemGroup(name);
        this.storeToDisk();
        this.changeObservable.updateObservers(this.getItemGroups());
        if (this.groups.isEmpty() && !MyPreferences.INSTANCE.areAllGroupsManuallyDeleted()) {
            MyPreferences.INSTANCE.setAllGroupsManuallyDeleted(true);
            new PreferencesPersistor().storeToDisk();
        }
    }

    private void doDeleteItemGroup(String name) {
        Iterator<NamedItemGroup> it = this.groups.iterator();
        while (it.hasNext()) {
            NamedItemGroup group = it.next();
            if (!group.getName().equals(name)) continue;
            it.remove();
            this.removeItemsPersistedContent(group);
            this.persistor.delete(group.getItemGroup().getFileName());
            return;
        }
    }

    private void removeItemsPersistedContent(NamedItemGroup group) {
        for (ClipboardItem clipboardItem : group.getItemGroup().getItems()) {
            clipboardItem.deletePersistedContent();
        }
    }

    public ItemGroup getItemGroup(String groupName) {
        for (NamedItemGroup namedItemGroup : this.getItemGroups()) {
            if (!namedItemGroup.getName().equals(groupName)) continue;
            return namedItemGroup.getItemGroup();
        }
        return null;
    }

    public void moveGroupToTop(String name) {
        Iterator<NamedItemGroup> iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            NamedItemGroup group = iterator.next();
            if (!group.getName().equals(name)) continue;
            iterator.remove();
            this.groups.add(0, group);
            this.storeToDisk();
            this.changeObservable.updateObservers(this.getItemGroups());
            return;
        }
    }
}

