/*
 * Decompiled with CFR 0.152.
 */
package kb;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.List;
import kb.utils.ObjectIO;
import kb.utils.Utils;

public abstract class ListPersistor<T> {
    public final void storeToDisc(List<T> elements, String fileName) {
        String xmlElements = this.getXML(elements);
        new ObjectIO().writeText(xmlElements, fileName);
        new ObjectIO().writeText(xmlElements, String.valueOf(fileName) + ".backup");
    }

    private String getXML(List<T> elements) {
        return this.createXStream().toXML(this.createXmlList(elements));
    }

    protected abstract List<?> createXmlList(List<T> var1);

    public final List<T> readFromDisk(String fileName) {
        List<T> result = this.doReadFromDisk(fileName);
        if (result.isEmpty()) {
            return this.doReadFromDisk(String.valueOf(fileName) + ".backup");
        }
        return result;
    }

    private List<T> doReadFromDisk(String fileName) {
        String xml = new ObjectIO().readText(fileName);
        if (xml == null || xml.trim().isEmpty()) {
            return ListPersistor.emptyList();
        }
        return this.convertToItems(this.fromXml(xml));
    }

    protected abstract List<T> convertToItems(List<?> var1);

    private List<?> fromXml(String xml) {
        try {
            List result = (List)this.createXStream().fromXML(xml);
            if (!Utils.areAllElementsCorrectlyTyped(result, this.getXmlElementClass())) {
                return ListPersistor.emptyList();
            }
            return result;
        }
        catch (Throwable e) {
            return ListPersistor.emptyList();
        }
    }

    protected abstract Class<?> getXmlElementClass();

    protected static <U> List<U> emptyList() {
        return new ArrayList();
    }

    protected abstract XStream createXStream();

    public final void delete(String fileName) {
        new ObjectIO().delete(fileName);
        new ObjectIO().delete(String.valueOf(fileName) + ".backup");
    }
}

