/*
 * Decompiled with CFR 0.152.
 */
package kb;

import javax.swing.UIManager;
import kb.gui.MainFrame;
import kb.gui.prefs.LookAndFeelPref;

public class LookAndFeelHandler {
    public static final LookAndFeelHandler INSTANCE = new LookAndFeelHandler();

    private LookAndFeelHandler() {
    }

    public synchronized boolean isNimbusSupported() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            if ("Nimbus".equals(info.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void setLookAndFeel(LookAndFeelPref lookAndFeelPref) {
        switch (lookAndFeelPref) {
            case NIMBUS: {
                this.setNimbusLookAndFeel();
                break;
            }
            case SYSTEM: {
                this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                break;
            }
            case METAL: {
                this.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
    }

    private void setNimbusLookAndFeel() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            if ("Nimbus".equals(info.getName())) {
                this.setLookAndFeel(info.getClassName());
            }
            ++n2;
        }
    }

    private void setLookAndFeel(String className) {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateLookAndFeel(LookAndFeelPref lookAndFeelPref) {
        this.setLookAndFeel(lookAndFeelPref);
        MainFrame.reinitMainFrame();
    }
}

