/*
 * Decompiled with CFR 0.152.
 */
package kb;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kb.ListPersistor;
import kb.gui.Key;
import kb.gui.OkComponentPopupMenuHolder;
import kb.gui.PreviewAreaPosition;
import kb.gui.prefs.LookAndFeelPref;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.OkActionPref;
import kb.gui.prefs.Size;

public class PreferencesPersistor {
    public static volatile boolean werePreferencesSaved = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeToDisk() {
        MyPreferences myPreferences = MyPreferences.INSTANCE;
        synchronized (myPreferences) {
            this.doStoreToDisk();
        }
    }

    private void doStoreToDisk() {
        new MyPersistor().storeToDisc(this.createXMLElements(), "prefs/pref");
    }

    private List<XMLElement> createXMLElements() {
        return Arrays.asList(this.createXMLElement());
    }

    private XMLElement createXMLElement() {
        MyPreferences preferences = MyPreferences.INSTANCE;
        XMLElement result = new XMLElement();
        result.autosaveImages = preferences.isAutosaveImages();
        result.autopasteKeyModifiers = preferences.getAutopasteKey().getModifiers();
        result.autopasteKeyCode = preferences.getAutopasteKey().getKeyCode();
        result.autostart = preferences.isAutostart();
        result.lookAndFeel = preferences.getLookAndFeelPref().name();
        result.mainFrameWidth = preferences.getMainFrameSize().getWidth();
        result.mainFrameHeight = preferences.getMainFrameSize().getHeight();
        result.paused = preferences.isPaused();
        result.itemPreviewHidden = preferences.isItemPreviewHidden();
        result.pasteMode = preferences.getOkActionPref().getPasteMode().name();
        result.selectionMode = preferences.getOkActionPref().getSelectionMode().name();
        result.showNameSearchColumn = preferences.isShowNameSearchColumn();
        result.showGroupSearchColumn = preferences.isShowGroupSearchColumn();
        result.tabsHidden = preferences.areTabsHidden();
        result.buttonsHidden = preferences.areButtonsHidden();
        result.groupComboBoxHidden = preferences.isGroupComboBoxHidden();
        result.toolbarHidden = preferences.isToolbarHidden();
        result.trayIconHidden = preferences.isTrayIconHidden();
        result.allGroupsManuallyDeleted = preferences.areAllGroupsManuallyDeleted();
        result.dividerLocation = preferences.getDividerLocation();
        result.previewAreaPosition = preferences.getPreviewAreaPosition().name();
        result.clipboardHistoryPreviewDialogLineWrap = preferences.isClipboardHistoryPreviewDialogLineWrap();
        result.namedItemsPreviewDialogLineWrap = preferences.isNamedItemsPreviewDialogLineWrap();
        result.previewAreaLineWrap = preferences.isPreviewAreaLineWrap();
        result.clipboardHistoryPreviewDialogWidth = preferences.getClipboardHistoryPreviewDialogSize().getWidth();
        result.clipboardHistoryPreviewDialogHeight = preferences.getClipboardHistoryPreviewDialogSize().getHeight();
        result.namedItemsPreviewDialogWidth = preferences.getNamedItemsPreviewDialogSize().getWidth();
        result.namedItemsPreviewDialogHeight = preferences.getNamedItemsPreviewDialogSize().getHeight();
        result.maxHistorySize = preferences.getMaxHistorySize();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromDisk() {
        MyPreferences myPreferences = MyPreferences.INSTANCE;
        synchronized (myPreferences) {
            this.doLoadFromDisk();
        }
    }

    private void doLoadFromDisk() {
        List list = new MyPersistor().readFromDisk("prefs/pref");
        if (!list.isEmpty()) {
            this.extractIntoPreferences((XMLElement)list.get(0));
            werePreferencesSaved = true;
        }
    }

    private void extractIntoPreferences(XMLElement xmlElement) {
        MyPreferences preferences = MyPreferences.INSTANCE;
        preferences.setAutopasteKey(new Key(xmlElement.autopasteKeyModifiers, xmlElement.autopasteKeyCode));
        preferences.setAutostart(xmlElement.autostart);
        preferences.setAutosaveImages(xmlElement.autosaveImages);
        this.setLookAndFeelPref(xmlElement, preferences);
        this.setMainFrameSize(preferences, xmlElement);
        preferences.setPaused(xmlElement.paused);
        preferences.setItemPreviewHidden(xmlElement.itemPreviewHidden);
        this.setOkActionPref(xmlElement, preferences);
        preferences.setShowNameSearchColumn(xmlElement.showNameSearchColumn);
        preferences.setShowGroupSearchColumn(xmlElement.showGroupSearchColumn);
        preferences.setTabsHidden(xmlElement.tabsHidden);
        preferences.setButtonsHidden(xmlElement.buttonsHidden);
        preferences.setGroupComboBoxHidden(xmlElement.groupComboBoxHidden);
        preferences.setToolbarHidden(xmlElement.toolbarHidden);
        preferences.setTrayIconHidden(xmlElement.trayIconHidden);
        preferences.setAllGroupsManuallyDeleted(xmlElement.allGroupsManuallyDeleted);
        preferences.setDividerLocation(xmlElement.dividerLocation);
        this.setPreviewAreaPosition(preferences, xmlElement);
        preferences.setClipboardHistoryPreviewDialogLineWrap(xmlElement.clipboardHistoryPreviewDialogLineWrap);
        preferences.setNamedItemsPreviewDialogLineWrap(xmlElement.namedItemsPreviewDialogLineWrap);
        preferences.setPreviewAreaLineWrap(xmlElement.previewAreaLineWrap);
        this.setClipboardHistoryPreviewDialogSize(xmlElement, preferences);
        this.setNamedItemsPreviewDialogSize(xmlElement, preferences);
        this.setMaxHistorySize(xmlElement, preferences);
    }

    private void setMaxHistorySize(XMLElement xmlElement, MyPreferences preferences) {
        if (xmlElement.maxHistorySize > 0 && xmlElement.maxHistorySize <= 3000) {
            preferences.setMaxHistorySize(xmlElement.maxHistorySize);
        }
    }

    private void setClipboardHistoryPreviewDialogSize(XMLElement xmlElement, MyPreferences preferences) {
        if (xmlElement.clipboardHistoryPreviewDialogWidth > 0 && xmlElement.clipboardHistoryPreviewDialogHeight > 0) {
            preferences.setClipboardHistoryPreviewDialogSize(new Size(xmlElement.clipboardHistoryPreviewDialogWidth, xmlElement.clipboardHistoryPreviewDialogHeight));
        }
    }

    private void setNamedItemsPreviewDialogSize(XMLElement xmlElement, MyPreferences preferences) {
        if (xmlElement.namedItemsPreviewDialogWidth > 0 && xmlElement.namedItemsPreviewDialogHeight > 0) {
            preferences.setNamedItemsPreviewDialogSize(new Size(xmlElement.namedItemsPreviewDialogWidth, xmlElement.namedItemsPreviewDialogHeight));
        }
    }

    private void setPreviewAreaPosition(MyPreferences preferences, XMLElement xmlElement) {
        PreviewAreaPosition previewAreaPosition = this.getPreviewAreaPosition(xmlElement);
        if (previewAreaPosition != null) {
            preferences.setPreviewAreaPosition(previewAreaPosition);
        }
    }

    private PreviewAreaPosition getPreviewAreaPosition(XMLElement xmlElement) {
        try {
            return PreviewAreaPosition.valueOf(xmlElement.previewAreaPosition);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void setOkActionPref(XMLElement xmlElement, MyPreferences preferences) {
        OkActionPref okActionPref = this.getOkActionPref(xmlElement);
        if (okActionPref != null) {
            preferences.setOkActionPref(okActionPref);
        }
    }

    private OkActionPref getOkActionPref(XMLElement xmlElement) {
        try {
            return new OkActionPref(OkComponentPopupMenuHolder.PasteMode.valueOf(xmlElement.pasteMode), OkComponentPopupMenuHolder.SelectionMode.valueOf(xmlElement.selectionMode));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void setMainFrameSize(MyPreferences preferences, XMLElement xmlElement) {
        if (xmlElement.mainFrameWidth > 0 && xmlElement.mainFrameHeight > 0) {
            preferences.setMainFrameSize(new Size(xmlElement.mainFrameWidth, xmlElement.mainFrameHeight));
        }
    }

    private void setLookAndFeelPref(XMLElement xmlElement, MyPreferences preferences) {
        LookAndFeelPref lookAndFeelPref = this.getLookAndFeelPref(xmlElement);
        if (lookAndFeelPref != null) {
            preferences.setLookAndFeelPref(lookAndFeelPref);
        }
    }

    private LookAndFeelPref getLookAndFeelPref(XMLElement xmlElement) {
        try {
            return LookAndFeelPref.valueOf(xmlElement.lookAndFeel);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static class MyPersistor
    extends ListPersistor<XMLElement> {
        private MyPersistor() {
        }

        @Override
        protected List<XMLElement> convertToItems(List<?> xmlList) {
            return new ArrayList<XMLElement>(xmlList);
        }

        @Override
        protected XStream createXStream() {
            XStream result = new XStream();
            result.alias("item", XMLElement.class);
            return result;
        }

        @Override
        protected List<?> createXmlList(List<XMLElement> elements) {
            return new ArrayList<XMLElement>(elements);
        }

        @Override
        protected Class<?> getXmlElementClass() {
            return XMLElement.class;
        }
    }

    private static class XMLElement {
        boolean autosaveImages;
        int autopasteKeyModifiers;
        int autopasteKeyCode;
        boolean autostart;
        String lookAndFeel;
        int mainFrameWidth;
        int mainFrameHeight;
        boolean paused;
        boolean itemPreviewHidden;
        String pasteMode;
        String selectionMode;
        boolean showNameSearchColumn;
        boolean showGroupSearchColumn;
        boolean tabsHidden;
        boolean buttonsHidden;
        boolean groupComboBoxHidden;
        boolean toolbarHidden;
        boolean trayIconHidden;
        boolean allGroupsManuallyDeleted;
        int dividerLocation;
        String previewAreaPosition;
        boolean clipboardHistoryPreviewDialogLineWrap;
        boolean namedItemsPreviewDialogLineWrap;
        boolean previewAreaLineWrap;
        int clipboardHistoryPreviewDialogWidth;
        int clipboardHistoryPreviewDialogHeight;
        int namedItemsPreviewDialogWidth;
        int namedItemsPreviewDialogHeight;
        int maxHistorySize;
        boolean autopaste;

        private XMLElement() {
        }
    }
}

