/*
 * Decompiled with CFR 0.152.
 */
package kb;

import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.TextClipboardContent;
import kb.utils.ObjectIO;

public class TextClipboardItem
extends ClipboardItem {
    private static final int MAX_SHORT_TEXT_LENGTH = 1024;
    private final String shortText;

    public TextClipboardItem(String displayText, String fileName, String name, String shortText) {
        super(displayText, fileName, name);
        this.shortText = shortText;
    }

    public TextClipboardItem(String content) {
        super(TextClipboardItem.createDisplayText(content), TextClipboardItem.createFile(content), null);
        this.shortText = TextClipboardItem.createShortText(content);
    }

    private static String createFile(String content) {
        if (content.length() > 1024) {
            return TextClipboardItem.storeInNewFile(content);
        }
        return null;
    }

    private static String storeInNewFile(String clipboardContents) {
        String fileName = TextClipboardItem.getNewFileName();
        new ObjectIO().writeText(clipboardContents, fileName);
        return fileName;
    }

    private static String createShortText(String text) {
        return text.length() > 1024 ? text.substring(0, 1024) : text;
    }

    private static String createDisplayText(String content) {
        return TextClipboardItem.createShortText(content.replaceAll("\\s+", " ").trim()).trim();
    }

    public String getShortText() {
        return this.shortText;
    }

    @Override
    public TextClipboardContent getContent() {
        return this.getFileName() == null ? new TextClipboardContent(this.shortText) : TextClipboardContent.createProxy(this.getFileName(), this.shortText);
    }

    @Override
    public boolean equalsByValue(ClipboardItem other, ClipboardContent otherContent) {
        if (!super.equalsByValue(other, otherContent)) {
            return false;
        }
        if (!(other instanceof TextClipboardItem)) {
            return false;
        }
        TextClipboardItem textItem = (TextClipboardItem)other;
        if (!this.shortText.equals(textItem.shortText)) {
            return false;
        }
        if (this.getFileName() == null && textItem.getFileName() == null) {
            return true;
        }
        if (this.getFileName() != null && textItem.getFileName() != null) {
            return this.getContent().equals(otherContent);
        }
        return false;
    }

    @Override
    public TextClipboardItem createClonedInstance() {
        TextClipboardItem result = new TextClipboardItem(this.getContent().getText());
        result.setName(this.getName());
        return result;
    }
}

