/*
 * Decompiled with CFR 0.152.
 */
package kb.clipboard;

import java.awt.AWTException;
import java.awt.Robot;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kb.ClipboardContent;
import kb.ClipboardManager;
import kb.ImageClipboardContent;
import kb.RobotSupport;
import kb.TextClipboardContent;
import kb.clipboard.ClipboardChangeChecker;
import kb.clipboard.ClipboardReader;
import kb.clipboard.ClipboardWriteTAE;
import kb.clipboard.ImageEqualityChecker;
import kb.clipboard.TransferableBuilder;
import kb.gui.Key;
import kb.gui.prefs.MyPreferences;
import kb.utils.ExecutorServices;
import kb.utils.Utils;

public class ClipboardAcessor {
    private static ClipboardAcessor INSTANCE;
    private ClipboardContent lastClipboardContent = null;
    private Robot robot;
    private ClipboardChangeChecker clipboardChangeChecker;

    private ClipboardAcessor() {
        this.initRobot();
        this.initClipboardChangeChecker();
    }

    public static void init() {
        ExecutorServices.CLIPBOARD_ACCESSOR_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                ClipboardAcessor.getInstance();
            }
        });
    }

    private void initClipboardChangeChecker() {
        this.clipboardChangeChecker = ClipboardChangeChecker.getInstance();
    }

    private void initRobot() {
        try {
            this.robot = new Robot();
            RobotSupport.INSTANCE.setRobotSupported(true);
        }
        catch (AWTException e) {
            RobotSupport.INSTANCE.setRobotSupported(false);
        }
    }

    private void checkClipboard() {
        ClipboardContent content;
        if (this.clipboardChangeChecker.isClipboardChanged() && this.updateLastClipboardContent(content = this.getClipboardContent())) {
            this.notifyClipboardManager(content);
        }
    }

    private boolean updateLastClipboardContent(ClipboardContent clipboardContent) {
        if (!(clipboardContent == null || this.isContentEmpty(clipboardContent) || this.lastClipboardContent != null && this.equalsToLast(clipboardContent))) {
            this.lastClipboardContent = clipboardContent;
            return true;
        }
        return false;
    }

    private boolean equalsToLast(ClipboardContent clipboardContent) {
        if (this.lastClipboardContent.getClass() != clipboardContent.getClass()) {
            return false;
        }
        if (clipboardContent instanceof ImageClipboardContent && this.lastClipboardContent instanceof ImageClipboardContent) {
            return new ImageEqualityChecker().areEquals(((ImageClipboardContent)this.lastClipboardContent).getImage(), ((ImageClipboardContent)clipboardContent).getImage());
        }
        return this.lastClipboardContent.equals(clipboardContent);
    }

    private boolean isContentEmpty(ClipboardContent clipboardContent) {
        return clipboardContent instanceof TextClipboardContent && ((TextClipboardContent)clipboardContent).getText().trim().isEmpty();
    }

    private ClipboardContent getClipboardContent() {
        return new ClipboardReader().getClipboardContent(MyPreferences.INSTANCE.isAutosaveImages());
    }

    private void notifyClipboardManager(final ClipboardContent clipboardContent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClipboardManager.getInstance().clipboardChanged(clipboardContent);
            }
        });
    }

    private void writeToClipboard(ClipboardContent content, boolean sendPaste) {
        ClipboardWriteTAE clipboardWriteTAE = new ClipboardWriteTAE(TransferableBuilder.createTransferable(content));
        clipboardWriteTAE.execute();
        if (clipboardWriteTAE.wasOperationSuccessful()) {
            this.afterSuccessfulWrite(content, sendPaste);
        }
    }

    private void afterSuccessfulWrite(ClipboardContent content, boolean sendPaste) {
        if (sendPaste) {
            Utils.sleepIgnoreInterrupt(50L);
            this.sendPaste();
        }
        this.updateLastClipboardContent(content);
    }

    private void sendPaste() {
        Key autopasteKey = MyPreferences.INSTANCE.getAutopasteKey();
        if (this.robot != null && autopasteKey != null) {
            this.doSendPaste(autopasteKey);
        }
    }

    private void doSendPaste(Key autopasteKey) {
        int modifiers = autopasteKey.getModifiers();
        boolean control = (modifiers & 2) != 0;
        boolean shift = (modifiers & 1) != 0;
        boolean alt = (modifiers & 8) != 0;
        boolean altGraph = (modifiers & 0x20) != 0;
        boolean meta = (modifiers & 4) != 0;
        this.pressModifierKeys(control, shift, alt, altGraph, meta);
        this.robot.keyPress(autopasteKey.getKeyCode());
        this.robot.keyRelease(autopasteKey.getKeyCode());
        this.releaseModifierKeys(control, shift, alt, altGraph, meta);
    }

    private void pressModifierKeys(boolean control, boolean shift, boolean alt, boolean altGraph, boolean meta) {
        if (control) {
            this.robot.keyPress(17);
        }
        if (shift) {
            this.robot.keyPress(16);
        }
        if (alt) {
            this.robot.keyPress(18);
        }
        if (altGraph) {
            this.robot.keyPress(65406);
        }
        if (meta) {
            this.robot.keyPress(157);
        }
    }

    private void releaseModifierKeys(boolean control, boolean shift, boolean alt, boolean altGraph, boolean meta) {
        if (meta) {
            this.robot.keyRelease(157);
        }
        if (altGraph) {
            this.robot.keyRelease(65406);
        }
        if (alt) {
            this.robot.keyRelease(18);
        }
        if (shift) {
            this.robot.keyRelease(16);
        }
        if (control) {
            this.robot.keyRelease(17);
        }
    }

    public static void writeToClipboard(ClipboardContent content) {
        ClipboardAcessor.submitWriteToClipboard(content, false);
    }

    private static Future<?> submitWriteToClipboard(final ClipboardContent content, final boolean sendPaste) {
        return ExecutorServices.CLIPBOARD_ACCESSOR_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                ClipboardAcessor.getInstance().writeToClipboard(content, sendPaste);
            }
        });
    }

    public static void checkForClipboardChangeAndWait() {
        try {
            ClipboardAcessor.submitClipboardChangeCheck().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkForClipboardChange() {
        ClipboardAcessor.submitClipboardChangeCheck();
    }

    private static Future<?> submitClipboardChangeCheck() {
        return ExecutorServices.CLIPBOARD_ACCESSOR_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                ClipboardAcessor.getInstance().checkClipboard();
            }
        });
    }

    private static ClipboardAcessor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClipboardAcessor();
        }
        return INSTANCE;
    }

    public static void writeToClipboardAndPaste(ClipboardContent content) {
        ClipboardAcessor.submitWriteToClipboard(content, true);
    }

    public static String getClipboardText() {
        try {
            return ClipboardAcessor.submitClipboardTextReading().get(3L, TimeUnit.SECONDS);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static Future<String> submitClipboardTextReading() {
        return ExecutorServices.CLIPBOARD_ACCESSOR_EXECUTOR_SERVICE.submit(new Callable<String>(){

            @Override
            public String call() {
                return ClipboardAcessor.getInstance().doGetClipboardText();
            }
        });
    }

    private String doGetClipboardText() {
        ClipboardContent clipboardContent = this.getClipboardContent();
        if (clipboardContent instanceof TextClipboardContent) {
            return ((TextClipboardContent)clipboardContent).getText();
        }
        return null;
    }
}

