/*
 * Decompiled with CFR 0.152.
 */
package kb.clipboard;

import com.sun.jna.Platform;
import kb.clipboard.DefaultClipboardChangeChecker;
import kb.clipboard.WindowsClipboardChangeChecker;

public abstract class ClipboardChangeChecker {
    private static ClipboardChangeChecker INSTANCE;

    public abstract boolean isClipboardChanged();

    public static ClipboardChangeChecker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ClipboardChangeChecker.createInstance();
        }
        return INSTANCE;
    }

    private static ClipboardChangeChecker createInstance() {
        try {
            return ClipboardChangeChecker.createPlatformSpecificInstance();
        }
        catch (Throwable e) {
            return new DefaultClipboardChangeChecker();
        }
    }

    private static ClipboardChangeChecker createPlatformSpecificInstance() {
        if (Platform.isWindows()) {
            return new WindowsClipboardChangeChecker();
        }
        return new DefaultClipboardChangeChecker();
    }
}

