/*
 * Decompiled with CFR 0.152.
 */
package kb.clipboard;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.ImageIcon;
import kb.ClipboardContent;
import kb.ImageClipboardContent;
import kb.TextClipboardContent;
import kb.utils.Utils;

class ClipboardReader {
    ClipboardReader() {
    }

    public ClipboardContent getClipboardContent(boolean readImage) {
        try {
            return this.readClipboardContent(readImage);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private ClipboardContent readClipboardContent(boolean readImage) throws Exception {
        Transferable transferable = Utils.getClipboard().getContents(null);
        if (transferable != null) {
            return this.getContent(transferable, readImage);
        }
        return null;
    }

    private ClipboardContent getContent(Transferable transferable, boolean readImage) throws Exception {
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return new TextClipboardContent((String)transferable.getTransferData(DataFlavor.stringFlavor));
        }
        if (readImage && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            return this.readImageContent(transferable);
        }
        return null;
    }

    private ClipboardContent readImageContent(Transferable transferable) throws Exception {
        ImageIcon icon = new ImageIcon((Image)transferable.getTransferData(DataFlavor.imageFlavor));
        if (icon.getImageLoadStatus() != 8) {
            return null;
        }
        return new ImageClipboardContent(icon.getImage());
    }
}

