/*
 * Decompiled with CFR 0.152.
 */
package kb.clipboard;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import kb.clipboard.ClipboardChangeChecker;
import kb.clipboard.JNAUtils;

public class WindowsClipboardChangeChecker
extends ClipboardChangeChecker {
    private volatile int sequnceNumberJNAResult;
    private int sequenceNumber = this.getSequenceNumber() - 1;

    private int getSequenceNumber() {
        try {
            SwingUtilities.invokeAndWait(this.createSequenceNumberRunnable());
            return this.sequnceNumberJNAResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 0;
        }
        catch (InvocationTargetException e) {
            return 0;
        }
    }

    private Runnable createSequenceNumberRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                WindowsClipboardChangeChecker.this.sequnceNumberJNAResult = JNAUtils.getClipboardSequenceNumber();
            }
        };
    }

    @Override
    public boolean isClipboardChanged() {
        int currentSequenceNumber = this.getSequenceNumber();
        if (this.sequenceNumber != currentSequenceNumber) {
            this.sequenceNumber = currentSequenceNumber;
            return true;
        }
        return false;
    }
}

