/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import kb.ClipboardManager;
import kb.gui.AboutPanel;
import kb.gui.GuiUtils;
import kb.gui.MainFrame;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton btnAppHomeFolder;
    private JButton btnClose;

    public AboutDialog() {
        super(MainFrame.getInstance(), "About Keepboard", true);
        this.addComponents();
        this.setDefaultCloseOperation(2);
        this.addActions();
        this.setSize(400, 330);
        this.setLocationRelativeTo(MainFrame.getInstance());
        this.setVisible(true);
    }

    private void addActions() {
        this.registerEscapeKey();
        this.addComponentListener();
    }

    private void addComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AboutDialog.this.btnClose.requestFocusInWindow();
            }
        });
    }

    private void registerEscapeKey() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "myEscape");
        this.getRootPane().getActionMap().put("myEscape", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.dispose();
            }
        });
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addAboutPanel();
        this.addButtonsPanel();
    }

    private void addAboutPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new AboutPanel(), c);
    }

    private void addButtonsPanel() {
        this.addAppHomeFolderButton();
        this.addCloseButton();
    }

    private void addAppHomeFolderButton() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 5, 0);
        c.weightx = 1.0;
        c.anchor = 17;
        this.add(this.createButtonAppHomeFolder(), c);
    }

    private Component createButtonAppHomeFolder() {
        this.btnAppHomeFolder = new JButton("Keepboard folder");
        this.btnAppHomeFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.displayAppHomeFolder();
            }
        });
        GuiUtils.setSize(this.btnAppHomeFolder, new Dimension(150, 30));
        return this.btnAppHomeFolder;
    }

    private void displayAppHomeFolder() {
        if (Desktop.isDesktopSupported()) {
            this.openAppHomeFolder();
        } else {
            this.displayAndCopyAppHomeFolderPath();
        }
    }

    private void openAppHomeFolder() {
        try {
            Desktop.getDesktop().open(new File(System.getProperty("user.dir")));
        }
        catch (Exception e) {
            this.displayAndCopyAppHomeFolderPath();
        }
    }

    private void displayAndCopyAppHomeFolderPath() {
        String homeFolderPath = System.getProperty("user.dir");
        ClipboardManager.getInstance().copyToClipboard(homeFolderPath);
        JOptionPane.showMessageDialog(this, "<html>Keepboard current working folder is: <b>" + homeFolderPath + "</b>.<br />This path has been copied to clipboard.</html>", "Keepboard folder", 1);
    }

    private void addCloseButton() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 5, 5);
        c.weightx = 1.0;
        c.anchor = 13;
        this.add((Component)this.createButtonClose(), c);
    }

    private JButton createButtonClose() {
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        GuiUtils.setSize(this.btnClose, new Dimension(100, 30));
        return this.btnClose;
    }
}

