/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kb.gui.GuiUtils;
import kb.gui.utils.HyperLinkPane;
import kb.utils.Utils;

public class AboutPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ImageIcon logo;
    private static final int logoHeight = 100;

    public AboutPanel() {
        this.setLayout(new GridBagLayout());
        this.addLogo();
        this.addInfo();
        this.addLicencePanel();
    }

    private static ImageIcon getLogo() {
        if (logo == null) {
            logo = AboutPanel.createLogo();
        }
        return logo;
    }

    private static ImageIcon createLogo() {
        Image image = new ImageIcon(Utils.getImage("myIcon.JPG")).getImage();
        double logoScaleRatio = 100 / image.getHeight(null);
        Image scaled = image.getScaledInstance((int)((double)image.getWidth(null) * logoScaleRatio), 100, 4);
        return new ImageIcon(scaled);
    }

    private void addLogo() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.add((Component)this.getImageLabel(), c);
    }

    private JLabel getImageLabel() {
        ImageIcon logo = AboutPanel.getLogo();
        JLabel imageLabel = new JLabel(logo);
        GuiUtils.setSize(imageLabel, new Dimension(logo.getImage().getWidth(null), logo.getImage().getHeight(null)));
        return imageLabel;
    }

    private void addInfo() {
        JPanel panel = new JPanel(new GridLayout(5, 1));
        JLabel label = new JLabel("Keepboard", 0);
        label.setFont(label.getFont().deriveFont(1, label.getFont().getSize() + 4));
        panel.add(label);
        panel.add(new JLabel("Version 4.3", 0));
        panel.add(new JLabel("Copyright 2011, 2012 Dragan Bozanovic", 0));
        panel.add(new HyperLinkPane("dragan.bozanovic@yahoo.com", HyperLinkPane.Mode.MAIL));
        panel.add(new HyperLinkPane("http://sourceforge.net/projects/keepboard/", HyperLinkPane.Mode.LINK));
        GuiUtils.setSize(panel, new Dimension(1, 100));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)panel, c);
    }

    private void addLicencePanel() {
        JTabbedPane pane = new JTabbedPane(1);
        pane.addTab("License", new JScrollPane(this.createLicenseEditorPane()));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.add((Component)pane, c);
    }

    private JEditorPane createLicenseEditorPane() {
        JEditorPane result = new JEditorPane("text/html", this.getLicenceShortText());
        result.setEditable(false);
        result.addHyperlinkListener(this.createLicenseHyperlinkListener());
        result.setCaretPosition(0);
        return result;
    }

    private HyperlinkListener createLicenseHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://www.gnu.org/licenses/"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private String getLicenceShortText() {
        return "<html>Keepboard is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.<br /><br />This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.<br /><br />You should have received a copy of the GNU General Public License along with this program.  If not, see <a href=\"http://www.gnu.org/licenses/\">http://www.gnu.org/licenses/</a>.</html>";
    }
}

