/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import kb.gui.GuiUtils;
import kb.gui.PopupMenuUtils;
import kb.utils.PopupMenuAdapter;

public class ActionsButtonBuilder {
    private JPopupMenu actionsMenu;
    private JToggleButton actionsButton;
    private int mnemonic = -1;
    private String text;
    private Icon icon;
    private Dimension size;
    private boolean onTop = false;

    public ActionsButtonBuilder(JPopupMenu actionsMenu) {
        this.actionsMenu = actionsMenu;
        this.addActionsMenuListener();
        PopupMenuUtils.addGlobalPopupMenuListener(actionsMenu);
    }

    private void addActionsMenuListener() {
        this.actionsMenu.addPopupMenuListener(new PopupMenuAdapter(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                ActionsButtonBuilder.this.actionsButton.setSelected(false);
            }
        });
    }

    public AbstractButton build() {
        this.actionsButton = new JToggleButton();
        this.actionsButton.addActionListener(this.createActionsButtonActionsListener());
        if (this.mnemonic >= 0) {
            this.actionsButton.setMnemonic(this.mnemonic);
        }
        if (this.icon != null) {
            this.actionsButton.setIcon(this.icon);
        }
        if (this.text != null) {
            this.actionsButton.setText(this.text);
        }
        if (this.size != null) {
            GuiUtils.setSize(this.actionsButton, this.size);
        }
        return this.actionsButton;
    }

    public ActionsButtonBuilder setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
        return this;
    }

    private ActionListener createActionsButtonActionsListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ActionsButtonBuilder.this.actionsButton.isSelected()) {
                    ActionsButtonBuilder.this.displayActionsMenu();
                } else {
                    ActionsButtonBuilder.this.actionsMenu.setVisible(false);
                }
            }
        };
    }

    private void displayActionsMenu() {
        int y;
        int x = this.actionsButton.getWidth() - this.actionsMenu.getPreferredSize().width;
        int n = y = this.onTop ? 0 : (int)this.actionsButton.getLocation().getY();
        y = this.onTop ? (y -= this.actionsMenu.getPreferredSize().height) : (y += this.actionsButton.getHeight());
        this.actionsMenu.show(this.actionsButton, x, y);
    }

    public ActionsButtonBuilder setText(String title) {
        this.text = title;
        return this;
    }

    public ActionsButtonBuilder setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public ActionsButtonBuilder setSize(Dimension size) {
        this.size = size;
        return this;
    }

    public ActionsButtonBuilder setOnTop() {
        this.onTop = true;
        return this;
    }
}

