/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kb.PreferencesPersistor;
import kb.TextClipboardItem;
import kb.gui.DialogClosingCommand;
import kb.gui.DialogClosingCommandsExecutor;
import kb.gui.MyInputDialog;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.Size;
import kb.gui.utils.TextAreaComponent;

public class ClipboardHistoryItemEditDialog
extends MyInputDialog<TextClipboardItem> {
    private static final long serialVersionUID = 1L;
    private static ClipboardHistoryItemEditDialog INSTANCE;
    private JPanel valuePanel;
    private TextAreaComponent textAreaComponent;
    private String itemToEditContent;

    private ClipboardHistoryItemEditDialog() {
        this.createAndAddComponents();
        DialogClosingCommandsExecutor.INSTANCE.addCommand(this.createDialogClosingCommand());
    }

    private DialogClosingCommand createDialogClosingCommand() {
        return new DialogClosingCommand(){

            @Override
            public void execute() {
                ClipboardHistoryItemEditDialog.this.executeDialogClosingCommand();
            }
        };
    }

    private void executeDialogClosingCommand() {
        this.executeLineWrapCommand();
        this.executeDialogResizeCommand();
    }

    private void executeLineWrapCommand() {
        boolean newValue;
        boolean oldValue = MyPreferences.INSTANCE.isClipboardHistoryPreviewDialogLineWrap();
        if (oldValue != (newValue = this.textAreaComponent.isLineWrap())) {
            MyPreferences.INSTANCE.setClipboardHistoryPreviewDialogLineWrap(newValue);
            new PreferencesPersistor().storeToDisk();
        }
    }

    private void executeDialogResizeCommand() {
        Size newSize;
        Size oldSize = MyPreferences.INSTANCE.getClipboardHistoryPreviewDialogSize();
        if (!oldSize.equals(newSize = new Size(this.getWidth(), this.getHeight()))) {
            MyPreferences.INSTANCE.setClipboardHistoryPreviewDialogSize(newSize);
            new PreferencesPersistor().storeToDisk();
        }
    }

    public static TextClipboardItem showDialog(TextClipboardItem itemToEdit) {
        ClipboardHistoryItemEditDialog.createInstanceIfNotCreated();
        INSTANCE.clearValue();
        INSTANCE.setItemToEdit(itemToEdit);
        INSTANCE.setVisible(true);
        return (TextClipboardItem)INSTANCE.getInputValue();
    }

    private static void createInstanceIfNotCreated() {
        if (INSTANCE == null || ClipboardHistoryItemEditDialog.INSTANCE.disposed) {
            INSTANCE = new ClipboardHistoryItemEditDialog();
        }
    }

    private void setItemToEdit(TextClipboardItem itemToEdit) {
        this.itemToEditContent = itemToEdit != null ? itemToEdit.getContent().getText() : null;
        this.setTitle(itemToEdit == null ? "New item" : "Edit item");
        this.initComponents();
    }

    private void createAndAddComponents() {
        this.valuePanel = this.createValuePanel();
        this.addActions();
        this.addDialogComponents();
        Size size = MyPreferences.INSTANCE.getClipboardHistoryPreviewDialogSize();
        this.setSize(size.getWidth(), size.getHeight());
    }

    private void addActions() {
        this.textAreaComponent.getTextArea().getDocument().addDocumentListener(this.createDocumentListener());
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClipboardHistoryItemEditDialog.this.checkButtonOkEnabledState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClipboardHistoryItemEditDialog.this.checkButtonOkEnabledState();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        };
    }

    private void checkButtonOkEnabledState() {
        this.getOkButton().setEnabled(!this.isItemContentEmpty() && this.isAnythingChanged());
    }

    private boolean isItemContentEmpty() {
        return this.textAreaComponent.getText().trim().isEmpty();
    }

    private boolean isAnythingChanged() {
        return this.itemToEditContent == null || !this.itemToEditContent.equals(this.textAreaComponent.getText());
    }

    private JPanel createValuePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this.createAndAddItemField(result);
        this.textAreaComponent.setLineWrap(MyPreferences.INSTANCE.isClipboardHistoryPreviewDialogLineWrap());
        return result;
    }

    private void initComponents() {
        this.adjustTxaItem();
        this.checkButtonOkEnabledState();
        this.textAreaComponent.getTextArea().requestFocusInWindow();
    }

    private void adjustTxaItem() {
        if (this.itemToEditContent != null) {
            this.textAreaComponent.setText(this.itemToEditContent);
            this.adjustTxaItemScrollbars();
        } else {
            this.textAreaComponent.setText("");
        }
    }

    private void adjustTxaItemScrollbars() {
        this.textAreaComponent.getTextArea().setCaretPosition(0);
    }

    private void createAndAddItemField(JPanel result) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.textAreaComponent = new TextAreaComponent();
        result.add(this.textAreaComponent.getComponent(), c);
    }

    @Override
    protected TextClipboardItem getValue() {
        return this.createValue();
    }

    private TextClipboardItem createValue() {
        return new TextClipboardItem(this.textAreaComponent.getText());
    }

    @Override
    protected JPanel getValuePanel() {
        return this.valuePanel;
    }
}

