/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kb.ClipboardItem;
import kb.ImageClipboardItem;
import kb.PreferencesPersistor;
import kb.TextClipboardItem;
import kb.gui.DialogClosingCommand;
import kb.gui.DialogClosingCommandsExecutor;
import kb.gui.PreviewAreaPosition;
import kb.gui.prefs.MyPreferences;
import kb.gui.utils.TextAreaComponent;

public class ContentPreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TextAreaComponent textAreaComponent;
    private JLabel imageLabel;

    public ContentPreviewPanel() {
        this.setLayout(new CardLayout());
        this.addComponents();
        this.adjustLineWrapCheckBoxVisibility();
        this.textAreaComponent.setLineWrap(MyPreferences.INSTANCE.isPreviewAreaLineWrap());
        DialogClosingCommandsExecutor.INSTANCE.addCommand(this.createDialogClosingCommand());
    }

    private DialogClosingCommand createDialogClosingCommand() {
        return new DialogClosingCommand(){

            @Override
            public void execute() {
                ContentPreviewPanel.this.executeLineWrapCommand();
            }
        };
    }

    private void executeLineWrapCommand() {
        boolean newValue;
        boolean oldValue = MyPreferences.INSTANCE.isPreviewAreaLineWrap();
        if (oldValue != (newValue = this.textAreaComponent.isLineWrap())) {
            MyPreferences.INSTANCE.setPreviewAreaLineWrap(newValue);
            new PreferencesPersistor().storeToDisk();
        }
    }

    public void adjustLineWrapCheckBoxVisibility() {
        PreviewAreaPosition previewAreaPosition = MyPreferences.INSTANCE.getPreviewAreaPosition();
        this.textAreaComponent.setLineWrapCheckBoxVisible(previewAreaPosition == PreviewAreaPosition.LEFT || previewAreaPosition == PreviewAreaPosition.RIGHT);
    }

    private void addComponents() {
        this.textAreaComponent = this.createTextAreaComponent();
        this.imageLabel = this.createImageLabel();
        this.add((Component)this.imageLabel, "image");
        this.add(this.textAreaComponent.getComponent(), "text");
    }

    private JLabel createImageLabel() {
        JLabel result = new JLabel();
        result.setHorizontalAlignment(0);
        return result;
    }

    private TextAreaComponent createTextAreaComponent() {
        TextAreaComponent result = new TextAreaComponent();
        result.getTextArea().setEditable(false);
        return result;
    }

    public void setContent(ClipboardItem clipboardItem) {
        if (clipboardItem == null) {
            this.setEmptyContent();
        } else if (clipboardItem instanceof TextClipboardItem) {
            this.setTextContent((TextClipboardItem)clipboardItem);
        } else {
            this.setImageContent((ImageClipboardItem)clipboardItem);
        }
    }

    private void setEmptyContent() {
        ((CardLayout)this.getLayout()).show(this, "image");
        this.imageLabel.setIcon(null);
    }

    private void setTextContent(TextClipboardItem clipboardItem) {
        ((CardLayout)this.getLayout()).show(this, "text");
        this.textAreaComponent.setText(clipboardItem.getShortText());
        if (clipboardItem.getFileName() != null) {
            this.textAreaComponent.getTextArea().append("\n <more text>...");
        }
        this.textAreaComponent.getTextArea().setCaretPosition(0);
    }

    private void setImageContent(ImageClipboardItem clipboardItem) {
        ((CardLayout)this.getLayout()).show(this, "image");
        this.imageLabel.setIcon(new ImageIcon(clipboardItem.getPreviewImage()));
    }
}

