/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import kb.PreferencesPersistor;
import kb.gui.MainFrame;
import kb.gui.PreviewAreaPosition;
import kb.gui.prefs.MyPreferences;

public class DividerLocationCalculator {
    private final JSplitPane splitPane;

    public DividerLocationCalculator(JSplitPane splitPane) {
        this.splitPane = splitPane;
    }

    public void addActions() {
        this.splitPane.addPropertyChangeListener("dividerLocation", this.createSplitPaneDividerLocationPropertyListener());
    }

    private PropertyChangeListener createSplitPaneDividerLocationPropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent changeEvent) {
                boolean itemPreviewHiddenNew;
                JSplitPane splitPane = (JSplitPane)changeEvent.getSource();
                boolean itemPreviewHiddenOld = MyPreferences.INSTANCE.isItemPreviewHidden();
                if (itemPreviewHiddenOld != (itemPreviewHiddenNew = DividerLocationCalculator.this.calcItemPreviewHiddenPrefValue(splitPane))) {
                    MyPreferences.INSTANCE.setItemPreviewHidden(itemPreviewHiddenNew);
                    new PreferencesPersistor().storeToDisk();
                }
            }
        };
    }

    private boolean calcItemPreviewHiddenPrefValue(JSplitPane splitPane) {
        PreviewAreaPosition previewAreaPosition = this.getPreviewAreaPositionPref();
        if (previewAreaPosition == PreviewAreaPosition.TOP || previewAreaPosition == PreviewAreaPosition.LEFT) {
            return splitPane.getDividerSize() + splitPane.getDividerLocation() < 5;
        }
        if (previewAreaPosition == PreviewAreaPosition.BOTTOM) {
            return splitPane.getHeight() - splitPane.getDividerSize() - splitPane.getDividerLocation() < 5;
        }
        return splitPane.getWidth() - splitPane.getDividerSize() - splitPane.getDividerLocation() < 5;
    }

    public void initDividerLocation() {
        int dividerLocation = this.getDividerLocationPref();
        if (dividerLocation == 0 && this.getPreviewAreaPositionPref() == PreviewAreaPosition.BOTTOM) {
            this.setSplitPaneDividerLocation(this.calculateDefaultDividerLocationForBottomPreviewArea());
        } else {
            this.setSplitPaneDividerLocation(dividerLocation);
        }
    }

    public void setDividerLocation() {
        this.setSplitPaneDividerLocation(this.getDividerLocationPref());
    }

    private void setSplitPaneDividerLocation(int dividerLocation) {
        this.splitPane.setDividerLocation(dividerLocation);
        if (MyPreferences.INSTANCE.isItemPreviewHidden()) {
            PreviewAreaPosition previewAreaPosition = this.getPreviewAreaPositionPref();
            if (previewAreaPosition == PreviewAreaPosition.TOP || previewAreaPosition == PreviewAreaPosition.LEFT) {
                this.splitPane.setDividerLocation(0);
            } else {
                this.splitPane.setDividerLocation(Integer.MAX_VALUE);
            }
        }
        this.storeDividerLocationIfChanged(dividerLocation);
    }

    private void storeDividerLocationIfChanged(int dividerLocation) {
        if (this.getDividerLocationPref() != dividerLocation) {
            MyPreferences.INSTANCE.setDividerLocation(dividerLocation);
            new PreferencesPersistor().storeToDisk();
        }
    }

    private int calculateDefaultDividerLocationForBottomPreviewArea() {
        int result = MyPreferences.INSTANCE.getMainFrameSize().getHeight() - 223;
        if (MyPreferences.INSTANCE.areButtonsHidden()) {
            result += 35;
        }
        if (MyPreferences.INSTANCE.isToolbarHidden()) {
            result += 23;
        }
        return result;
    }

    public void setDividerLocationAfterButtonsVisibilityChange(boolean buttonsVisible) {
        if (this.getPreviewAreaPositionPref() == PreviewAreaPosition.BOTTOM) {
            this.setSplitPaneDividerLocation(this.getDividerLocationPref() + (buttonsVisible ? -35 : 35));
        }
    }

    public void setDividerLocationAfterToolbarVisibilityChange(boolean toolbarVisible) {
        if (this.getPreviewAreaPositionPref() == PreviewAreaPosition.BOTTOM) {
            this.setSplitPaneDividerLocation(this.getDividerLocationPref() + (toolbarVisible ? -23 : 23));
        }
    }

    private int getDividerLocationPref() {
        return MyPreferences.INSTANCE.getDividerLocation();
    }

    private PreviewAreaPosition getPreviewAreaPositionPref() {
        return MyPreferences.INSTANCE.getPreviewAreaPosition();
    }

    public void setDividerLocationAfterPreviewAreaPositionChange() {
        PreviewAreaPosition previewAreaPosition = this.getPreviewAreaPositionPref();
        if (previewAreaPosition == PreviewAreaPosition.TOP) {
            this.setSplitPaneDividerLocation(90);
        } else if (previewAreaPosition == PreviewAreaPosition.BOTTOM) {
            this.setSplitPaneDividerLocation(this.calculateDefaultDividerLocationForBottomPreviewArea());
        } else if (previewAreaPosition == PreviewAreaPosition.LEFT) {
            this.setSplitPaneDividerLocation(400);
        } else {
            this.setSplitPaneDividerLocation(MainFrame.getInstance().getWidth() - 400);
        }
    }
}

