/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kb.ImageClipboardItem;
import kb.gui.MyInputDialog;
import kb.utils.Utils;

public class ImageItemDialog
extends MyInputDialog<Boolean> {
    private static final long serialVersionUID = 1L;
    private static ImageItemDialog INSTANCE;
    private JPanel valuePanel;
    private JLabel lblName;
    private JTextField txtName;
    private JLabel imageLabel;
    private boolean editName;
    private ImageClipboardItem item;

    private ImageItemDialog() {
        this.createAndAddComponents();
    }

    public static Boolean showDialog(ImageClipboardItem item, boolean editName) {
        ImageItemDialog.createInstanceIfNotCreated();
        INSTANCE.clearValue();
        INSTANCE.setItem(item, editName);
        INSTANCE.setVisible(true);
        return (Boolean)INSTANCE.getInputValue();
    }

    private static void createInstanceIfNotCreated() {
        if (INSTANCE == null || ImageItemDialog.INSTANCE.disposed) {
            INSTANCE = new ImageItemDialog();
        }
    }

    private void createAndAddComponents() {
        this.valuePanel = this.createValuePanel();
        this.addDialogComponents();
        this.addActions();
        this.setSize(600, 400);
    }

    private JPanel createValuePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this.createAndAddNameField(result);
        this.createAndAddItemField(result);
        return result;
    }

    private void createAndAddNameField(JPanel result) {
        this.txtName = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.lblName = this.createTxtNameLabel();
        result.add((Component)this.lblName, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        result.add((Component)this.txtName, c);
    }

    private JLabel createTxtNameLabel() {
        JLabel result = new JLabel("Name: ");
        result.setLabelFor(this.txtName);
        result.setDisplayedMnemonic(69);
        return result;
    }

    private void createAndAddItemField(JPanel result) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 2;
        c.insets = new Insets(7, 0, 0, 0);
        this.imageLabel = this.createImageLabel();
        result.add((Component)this.imageLabel, c);
    }

    private JLabel createImageLabel() {
        JLabel result = new JLabel();
        result.setHorizontalAlignment(0);
        return result;
    }

    private void setItem(ImageClipboardItem item, boolean editName) {
        this.item = item;
        this.editName = editName;
        this.setTitle(editName ? "Edit image item name" : "Image preview");
        this.initComponents();
        this.checkButtonOkEnabledState();
    }

    private void initComponents() {
        this.txtName.setVisible(this.editName);
        this.lblName.setVisible(this.editName);
        this.getOkButton().setVisible(this.editName);
        this.getCancelButton().setText(this.editName ? "Cancel" : "Close");
        this.txtName.setText(this.editName ? this.item.getName() : "");
        this.imageLabel.setIcon(new ImageIcon(Utils.scale(this.item.getContent().getImage(), 580, 280)));
        this.txtName.requestFocusInWindow();
    }

    private void checkButtonOkEnabledState() {
        this.getOkButton().setEnabled(this.editName && !this.txtName.getText().trim().isEmpty() && !this.item.getName().equals(this.txtName.getText()));
    }

    private void addActions() {
        this.txtName.getDocument().addDocumentListener(this.createDocumentListener());
        this.txtName.addFocusListener(this.createTxtNameFocusListener());
    }

    private FocusListener createTxtNameFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ImageItemDialog.this.txtName.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ImageItemDialog.this.txtName.select(0, 0);
            }
        };
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImageItemDialog.this.checkButtonOkEnabledState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImageItemDialog.this.checkButtonOkEnabledState();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        };
    }

    @Override
    protected Boolean getValue() {
        this.item.setName(this.txtName.getText());
        return true;
    }

    @Override
    protected JPanel getValuePanel() {
        return this.valuePanel;
    }
}

