/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import kb.ItemGroupHolder;
import kb.NamedItemGroup;
import kb.UserException;
import kb.gui.GuiUtils;
import kb.gui.ItemGroupModificationDialog;
import kb.gui.MainFrame;
import kb.gui.MyInputDialog;
import kb.gui.utils.TablePanel;
import kb.gui.utils.TablePanelBuilder;
import kb.utils.Observer;

public class ItemGroupChooser
extends MyInputDialog<String> {
    private static final long serialVersionUID = 1L;
    private static ItemGroupChooser INSTANCE;
    private TablePanel<Model> valuePanel = this.createValuePanel();
    private JTable table;
    private Model model;
    private String value;

    private ItemGroupChooser() {
        this.addActions();
        this.addDialogComponents();
        this.setSize(400, 300);
    }

    public static String showDialog(String title) {
        ItemGroupChooser.createInstanceIfNotCreated();
        INSTANCE.clearValue();
        ItemGroupChooser.INSTANCE.value = null;
        INSTANCE.initComponents(title);
        INSTANCE.setVisible(true);
        return (String)INSTANCE.getInputValue();
    }

    private void initComponents(String title) {
        this.setTitle(title);
        this.model.setData(this.getItemGroupNames());
        this.disableOkButton();
        this.valuePanel.clearFilter();
        this.selectFirstTableRow();
        this.valuePanel.focusFilterField();
    }

    private static void createInstanceIfNotCreated() {
        if (INSTANCE == null || ItemGroupChooser.INSTANCE.disposed) {
            INSTANCE = new ItemGroupChooser();
        }
    }

    private void disableOkButton() {
        this.getOkButton().setEnabled(false);
    }

    private void selectFirstTableRow() {
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void addActions() {
        this.table.getSelectionModel().addListSelectionListener(this.crateTableSelectionListener());
    }

    private ListSelectionListener crateTableSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ItemGroupChooser.this.getOkButton().setEnabled(ItemGroupChooser.this.isGroupSelected());
            }
        };
    }

    private TablePanel<Model> createValuePanel() {
        TablePanel<Model> result = this.createTablePanel();
        result.getApprovalObservable().addObserver(this.createActionObserver());
        return result;
    }

    private TablePanel<Model> createTablePanel() {
        this.table = this.createTable();
        return new TablePanelBuilder(this.table).setFilterFieldLabelText("Group: ").setFilterFieldLabelMnemonic(71).setCustomActionsComponent(this.createButtonNew()).build();
    }

    private Component createButtonNew() {
        JButton result = new JButton("New...");
        result.setMnemonic(78);
        result.addActionListener(this.createButtonNewActionListener());
        GuiUtils.setSize(result, new Dimension(80, 25));
        return result;
    }

    private ActionListener createButtonNewActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ItemGroupChooser.this.buttonNewActionPerformed();
            }
        };
    }

    private void buttonNewActionPerformed() {
        String newGroup = ItemGroupModificationDialog.showDialog(null);
        if (newGroup != null) {
            this.addNewGroupAndConfirmInput(newGroup);
        }
    }

    private void addNewGroupAndConfirmInput(String newGroup) {
        try {
            ItemGroupHolder.getInstance().addNewItemGroup(newGroup);
            this.confirmInput(newGroup);
        }
        catch (UserException e) {
            MainFrame.getInstance().displayErrorMessage(e.getMessage());
        }
    }

    private void confirmInput(String chosenGroup) {
        this.value = chosenGroup;
        this.inputConfirmed();
    }

    private Observer<Integer> createActionObserver() {
        return new Observer<Integer>(){

            @Override
            public void update(Integer data) {
                if (ItemGroupChooser.this.isGroupSelected()) {
                    String chosenGroup = ItemGroupChooser.this.createValue();
                    ItemGroupHolder.getInstance().moveGroupToTop(chosenGroup);
                    ItemGroupChooser.this.confirmInput(chosenGroup);
                }
            }
        };
    }

    private boolean isGroupSelected() {
        return this.table.getSelectedRow() >= 0;
    }

    private JTable createTable() {
        this.model = new Model();
        JTable result = new JTable(this.model);
        result.setTableHeader(null);
        result.setSelectionMode(0);
        return result;
    }

    private List<String> getItemGroupNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (NamedItemGroup namedItemGroup : ItemGroupHolder.getInstance().getItemGroups()) {
            result.add(namedItemGroup.getName());
        }
        return result;
    }

    @Override
    protected String getValue() {
        if (this.value == null) {
            this.value = this.createValue();
        }
        return this.value;
    }

    private String createValue() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            return this.model.getItemAt(this.table.convertRowIndexToModel(selectedRow));
        }
        return null;
    }

    @Override
    protected JPanel getValuePanel() {
        return this.valuePanel;
    }

    private static class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int ITEM_GROUP_NAME = 0;
        private static final String[] columnNames = new String[]{"Group"};
        private List<String> items = new ArrayList<String>(0);

        public void setData(List<String> items) {
            this.items = items;
            this.fireTableDataChanged();
        }

        public String getItemAt(int rowIndex) {
            return this.items.get(rowIndex);
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.items.get(rowIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }
    }
}

