/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kb.ClipboardItem;
import kb.ItemGroup;
import kb.ItemGroupHolder;
import kb.NamedItemGroup;
import kb.UserException;
import kb.gui.ActionsButtonBuilder;
import kb.gui.GuiUtils;
import kb.gui.ItemGroupComboPanelActionsMenuHolder;
import kb.gui.ItemGroupModificationDialog;
import kb.gui.ItemGroupPanel;
import kb.gui.MainFrame;
import kb.utils.Observer;

public class ItemGroupComboPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cmbItemGroup;
    private Component itemGroupActionsButton;
    private ItemGroupHolder itemGroupHolder;
    private ItemGroupComboPanelActionsMenuHolder actionsMenuHolder;
    private ItemGroupPanel itemGroupPanel;

    public ItemGroupComboPanel(ItemGroupPanel itemGroupPanel) {
        this.itemGroupPanel = itemGroupPanel;
        this.itemGroupHolder = ItemGroupHolder.getInstance();
        this.createComponents();
        this.addComponents();
        this.initComponents();
        this.addActions();
    }

    private void addActions() {
        this.addCmbItemGroupAction();
        this.addItemGroupActionsMenuActions();
        this.addItemGroupsObservers();
        this.addItemGroupHolderObserver();
    }

    private void addItemGroupHolderObserver() {
        Observer<List<NamedItemGroup>> changeObserver = this.createChangeObserver();
        this.itemGroupHolder.getChangeObservable().addObserver(changeObserver);
        MainFrame.getInstance().registerObserver(changeObserver, this.itemGroupHolder.getChangeObservable());
        Observer<NamedItemGroup> groupCreationObserver = this.createGroupCreationObserver();
        this.itemGroupHolder.getGroupCreationObservable().addObserver(groupCreationObserver);
        MainFrame.getInstance().registerObserver(groupCreationObserver, this.itemGroupHolder.getGroupCreationObservable());
    }

    private Observer<NamedItemGroup> createGroupCreationObserver() {
        return new Observer<NamedItemGroup>(){

            @Override
            public void update(NamedItemGroup data) {
                ItemGroupComboPanel.this.addItemGroupObserver(data.getItemGroup());
                ItemGroupComboPanel.this.setCmbItemGroupsData();
            }
        };
    }

    private Observer<List<NamedItemGroup>> createChangeObserver() {
        return new Observer<List<NamedItemGroup>>(){

            @Override
            public void update(List<NamedItemGroup> data) {
                ItemGroupComboPanel.this.setCmbItemGroupsData();
            }
        };
    }

    private void addItemGroupsObservers() {
        for (NamedItemGroup namedItemGroup : this.itemGroupHolder.getItemGroups()) {
            this.addItemGroupObserver(namedItemGroup.getItemGroup());
        }
    }

    private void addItemGroupObserver(ItemGroup itemGroup) {
        Observer<List<ClipboardItem>> observer = this.createItemGroupItemsObserver(itemGroup);
        itemGroup.getObservable().addObserver(observer);
        MainFrame.getInstance().registerObserver(observer, itemGroup.getObservable());
    }

    private Observer<List<ClipboardItem>> createItemGroupItemsObserver(final ItemGroup itemGroup) {
        return new Observer<List<ClipboardItem>>(){

            @Override
            public void update(List<ClipboardItem> data) {
                if (ItemGroupComboPanel.this.getSelectedNamedGroup().getItemGroup() == itemGroup) {
                    ItemGroupComboPanel.this.itemGroupPanel.itemGroupSelectionChanged();
                }
            }
        };
    }

    private void addItemGroupActionsMenuActions() {
        this.actionsMenuHolder.getMiNew().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemGroupComboPanel.this.createNewItemGroup();
            }
        });
        this.actionsMenuHolder.getMiRename().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemGroupComboPanel.this.renameItemGroup();
            }
        });
        this.actionsMenuHolder.getMiDelete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemGroupComboPanel.this.deleteItemGroup();
            }
        });
    }

    private void deleteItemGroup() {
        NamedItemGroup selectedGroup = this.getSelectedNamedGroup();
        if (selectedGroup != null && MainFrame.getInstance().displayConfirmationMessage("Delete group '" + selectedGroup.getName() + "'?")) {
            this.itemGroupHolder.deleteItemGroup(selectedGroup.getName());
        }
    }

    private void renameItemGroup() {
        String itemGroupNewName;
        NamedItemGroup selectedGroup = this.getSelectedNamedGroup();
        if (selectedGroup != null && (itemGroupNewName = ItemGroupModificationDialog.showDialog(selectedGroup.getName())) != null && !itemGroupNewName.isEmpty()) {
            this.renameItemGroup(selectedGroup.getName(), itemGroupNewName);
        }
    }

    private void renameItemGroup(String oldName, String newName) {
        try {
            this.itemGroupHolder.renameItemGroup(oldName, newName);
            this.selectGroup(newName);
        }
        catch (UserException e) {
            MainFrame.getInstance().displayErrorMessage(e.getMessage());
        }
    }

    public void selectGroup(String name) {
        int groupIndex = this.getGroupIndex(name);
        if (groupIndex >= 0) {
            this.cmbItemGroup.setSelectedIndex(groupIndex);
        }
    }

    private int getGroupIndex(String name) {
        int i = 0;
        int n = this.cmbItemGroup.getItemCount();
        while (i < n) {
            if (this.convert(this.cmbItemGroup.getItemAt(i)).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private NamedItemGroup convert(Object object) {
        return (NamedItemGroup)object;
    }

    private void createNewItemGroup() {
        String newItemGroupName = ItemGroupModificationDialog.showDialog(null);
        if (newItemGroupName != null && !newItemGroupName.isEmpty()) {
            this.addNewItemGroup(newItemGroupName);
        }
    }

    private void addNewItemGroup(String name) {
        try {
            this.itemGroupHolder.addNewItemGroup(name);
            this.selectGroup(name);
        }
        catch (UserException e) {
            MainFrame.getInstance().displayErrorMessage(e.getMessage());
        }
    }

    private void addCmbItemGroupAction() {
        this.cmbItemGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ItemGroupComboPanel.this.itemGroupPanel.itemGroupSelectionChanged();
                ItemGroupComboPanel.this.actionsMenuHolder.setGroupSelectionDependentMenuItemsEnabled(ItemGroupComboPanel.this.cmbItemGroup.getItemCount() > 0);
            }
        });
    }

    private void initComponents() {
        this.setCmbItemGroupsData();
        this.actionsMenuHolder.setGroupSelectionDependentMenuItemsEnabled(this.cmbItemGroup.getItemCount() > 0);
    }

    private void setCmbItemGroupsData() {
        NamedItemGroup seletedGroup = this.getSelectedNamedGroup();
        this.cmbItemGroup.removeAllItems();
        for (NamedItemGroup namedItemGroup : this.itemGroupHolder.getItemGroups()) {
            this.cmbItemGroup.addItem(namedItemGroup);
        }
        if (seletedGroup != null) {
            this.selectGroup(seletedGroup.getName());
        }
    }

    private void createComponents() {
        this.createCmbItemGroups();
        this.createItemGroupActionsButton();
    }

    private void createItemGroupActionsButton() {
        this.actionsMenuHolder = new ItemGroupComboPanelActionsMenuHolder();
        this.itemGroupActionsButton = new ActionsButtonBuilder(this.actionsMenuHolder.getPopupMenu()).setMnemonic(79).setText("Actions").setSize(new Dimension(90, 25)).build();
    }

    private void createCmbItemGroups() {
        this.cmbItemGroup = new JComboBox();
        GuiUtils.setSize(this.cmbItemGroup, new Dimension(50, 25));
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addItemsGruopLabel();
        this.addCmbItemGroups();
        this.addItemGroupActionsButton();
    }

    private void addItemsGruopLabel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.createCmbGroupLabel(), c);
    }

    private JLabel createCmbGroupLabel() {
        JLabel result = new JLabel("Group: ");
        result.setLabelFor(this.cmbItemGroup);
        result.setDisplayedMnemonic(71);
        return result;
    }

    private void addCmbItemGroups() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.cmbItemGroup, c);
    }

    private void addItemGroupActionsButton() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.add(this.itemGroupActionsButton, c);
    }

    public NamedItemGroup getSelectedNamedGroup() {
        return (NamedItemGroup)this.cmbItemGroup.getSelectedItem();
    }
}

