/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kb.gui.MyInputDialog;

public class ItemGroupModificationDialog
extends MyInputDialog<String> {
    private static final long serialVersionUID = 1L;
    private static ItemGroupModificationDialog INSTANCE;
    private String name;
    private JPanel valuePanel;
    private JTextField textField;
    private JLabel label;

    private ItemGroupModificationDialog() {
        this.createComponents();
    }

    public static String showDialog(String name) {
        ItemGroupModificationDialog.createInstanceIfNotCreated();
        INSTANCE.clearValue();
        INSTANCE.initComponents(name);
        INSTANCE.setVisible(true);
        return (String)INSTANCE.getInputValue();
    }

    private void initComponents(String name) {
        this.name = name;
        this.label.setText(name == null ? "Group name: " : "Group new name: ");
        this.textField.setText(name != null ? name : "");
        this.setTitle(name == null ? "New saved items group" : "Rename saved items group");
        this.checkOkButtonEnabledState();
        this.textField.requestFocusInWindow();
    }

    private static void createInstanceIfNotCreated() {
        if (INSTANCE == null || ItemGroupModificationDialog.INSTANCE.disposed) {
            INSTANCE = new ItemGroupModificationDialog();
        }
    }

    private void createComponents() {
        this.createValuePanel();
        this.addDialogComponents();
        this.setSize(400, 120);
    }

    private void createValuePanel() {
        this.valuePanel = new JPanel(new BorderLayout());
        this.valuePanel.add(this.createContentValuePanel(), "North");
        this.addTextFieldActions();
    }

    private Component createContentValuePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this.addLabel(result);
        this.addTextField(result);
        return result;
    }

    private void addTextFieldActions() {
        this.textField.getDocument().addDocumentListener(this.createDocumentListener());
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ItemGroupModificationDialog.this.checkOkButtonEnabledState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ItemGroupModificationDialog.this.checkOkButtonEnabledState();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        };
    }

    private void checkOkButtonEnabledState() {
        String text = this.textField.getText().trim();
        this.getOkButton().setEnabled(!text.isEmpty() && (this.name == null || !this.name.equals(text)) && !text.toLowerCase().startsWith("<html>"));
    }

    private void addLabel(JPanel panel) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.label = new JLabel();
        panel.add(this.label);
    }

    private void addTextField(JPanel panel) {
        this.textField = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.textField, c);
    }

    @Override
    protected JPanel getValuePanel() {
        return this.valuePanel;
    }

    @Override
    protected String getValue() {
        return this.textField.getText().trim();
    }
}

