/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.ImageClipboardItem;
import kb.ItemGroup;
import kb.ItemGroupHolder;
import kb.NamedItemGroup;
import kb.TextClipboardItem;
import kb.gui.ImageItemDialog;
import kb.gui.ItemGroupChooser;
import kb.gui.ItemGroupComboPanel;
import kb.gui.ItemGroupPanelActionsMenuHolder;
import kb.gui.MainFrame;
import kb.gui.MainFramePanel;
import kb.gui.NamedItemEditDialog;
import kb.gui.NamedItemsModel;
import kb.gui.prefs.MyPreferences;
import kb.gui.utils.TablePanel;
import kb.gui.utils.TablePanelBuilder;
import kb.gui.utils.TablePanelPopupMenusHolder;
import kb.utils.Observer;

public class ItemGroupPanel
extends MainFramePanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private NamedItemsModel namedItemsModel;
    private TablePanel<NamedItemsModel> tablePanel;
    private ItemGroupComboPanel itemGroupComboPanel;
    private ItemGroupPanelActionsMenuHolder actionsMenuHolder;

    public ItemGroupPanel() {
        this.createComponents();
        this.addComponents();
        this.initComponents();
        this.addActions();
    }

    public ItemGroupComboPanel getItemGroupComboPanel() {
        return this.itemGroupComboPanel;
    }

    private void addActions() {
        this.addTableApprovalObservable();
        this.addTableDeleteObserver();
        this.addTableSelectionListener();
        this.addItemGroupHolderListener();
    }

    private void addItemGroupHolderListener() {
        ItemGroupHolder itemGroupHolder = ItemGroupHolder.getInstance();
        Observer<?> changeObserver = this.createItemGroupHolderObserver();
        itemGroupHolder.getChangeObservable().addObserver(changeObserver);
        MainFrame.getInstance().registerObserver(changeObserver, itemGroupHolder.getChangeObservable());
        Observer<?> creationObserver = this.createItemGroupHolderObserver();
        itemGroupHolder.getGroupCreationObservable().addObserver(creationObserver);
        MainFrame.getInstance().registerObserver(creationObserver, itemGroupHolder.getGroupCreationObservable());
    }

    private Observer<?> createItemGroupHolderObserver() {
        return new Observer<Object>(){

            @Override
            public void update(Object data) {
                ItemGroupPanel.this.setMitCreateNewEnabledState();
            }
        };
    }

    private void addTableDeleteObserver() {
        this.tablePanel.getDeleteObservable().addObserver(new Observer<int[]>(){

            @Override
            public void update(int[] data) {
                ItemGroupPanel.this.deleteSelectedItems();
            }
        });
    }

    private void addTableSelectionListener() {
        this.table.getSelectionModel().addListSelectionListener(this.crateTableSelectionListener());
    }

    private ListSelectionListener crateTableSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ItemGroupPanel.this.actionsMenuHolder.setTableSelectionDependentMenuItemsEnabled(ItemGroupPanel.this.isAnyTableRowSelected());
                ItemGroupPanel.this.getSelectionObservable().updateObservers(ItemGroupPanel.this.getSelectedItem());
            }
        };
    }

    private boolean isAnyTableRowSelected() {
        return this.table.getSelectedRow() >= 0;
    }

    private void addTableApprovalObservable() {
        this.tablePanel.getApprovalObservable().addObserver(this.createTableApprovalObserver());
    }

    @Override
    public ClipboardContent getSelectedClipboardItemContent() {
        ClipboardItem result = this.getSelectedItem();
        if (result != null) {
            return result.getContent();
        }
        return null;
    }

    private Observer<Integer> createTableApprovalObserver() {
        return new Observer<Integer>(){

            @Override
            public void update(Integer data) {
                ItemGroupPanel.this.getApprovalObservable().updateObservers(ItemGroupPanel.this.getSelectedClipboardItemContent());
            }
        };
    }

    private void selectFirstRow() {
        if (this.table.getRowCount() > 0) {
            this.selectTableRows(new int[1]);
            this.scrollToTop();
        }
    }

    private void addItemsActions(ItemGroupPanelActionsMenuHolder menuHolder) {
        menuHolder.getMiNew().addActionListener(this.createMitNewActionListener());
        menuHolder.getMiEdit().addActionListener(this.createMitEditActionListener());
        menuHolder.getMiDelete().addActionListener(this.createMitDeleteActionListener());
        menuHolder.getMiCopy().addActionListener(this.crateMitCopyActionListener());
        menuHolder.getMiMove().addActionListener(this.createMitMoveActionListener());
    }

    private ActionListener createMitMoveActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemGroupPanel.this.moveSelectedItemsToItemGroup();
            }
        };
    }

    private void moveSelectedItemsToItemGroup() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (!selectedItems.isEmpty()) {
            this.moveItemsToGroup(this.getSelectedGroup(), selectedItems);
        }
    }

    private void moveItemsToGroup(ItemGroup fromGroup, List<ClipboardItem> selectedItems) {
        if (this.copyItemsToGroup(selectedItems, true)) {
            this.deleteItems(fromGroup, selectedItems);
        }
    }

    private ActionListener crateMitCopyActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ItemGroupPanel.this.copySelectedItemsToGroup();
            }
        };
    }

    @Override
    public void copySelectedItemsToGroup() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (!selectedItems.isEmpty()) {
            this.copyItemsToGroup(selectedItems, false);
        }
    }

    private boolean copyItemsToGroup(List<ClipboardItem> selectedItems, boolean move) {
        String groupName = ItemGroupChooser.showDialog(move ? "Move items to group" : "Copy items to group");
        if (groupName != null && !groupName.isEmpty()) {
            this.copyItemsToGroup(selectedItems, groupName);
            return !groupName.equals(this.itemGroupComboPanel.getSelectedNamedGroup().getName());
        }
        return false;
    }

    private void copyItemsToGroup(List<ClipboardItem> selectedItems, String groupName) {
        ItemGroup itemGroup = ItemGroupHolder.getInstance().getItemGroup(groupName);
        Collections.reverse(selectedItems);
        for (ClipboardItem clipboardItem : selectedItems) {
            itemGroup.addOrMoveItemToTop(clipboardItem.createClonedInstance());
        }
    }

    private ActionListener createMitDeleteActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ItemGroupPanel.this.deleteSelectedItems();
            }
        };
    }

    @Override
    public void deleteSelectedItems() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (!selectedItems.isEmpty() && this.confirmDeletion()) {
            this.deleteItems(this.getSelectedGroup(), selectedItems);
        }
    }

    private boolean confirmDeletion() {
        return MainFrame.getInstance().displayConfirmationMessage("Delete selected items?");
    }

    private void deleteItems(ItemGroup fromGroup, List<ClipboardItem> selectedItems) {
        for (ClipboardItem IClipboardItem : selectedItems) {
            fromGroup.deleteItem(IClipboardItem);
        }
    }

    private ActionListener createMitEditActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemGroupPanel.this.openSelectedItem();
            }
        };
    }

    @Override
    public void openSelectedItem() {
        ClipboardItem item = this.getSelectedItem();
        if (item != null) {
            int[] selectedRows = this.table.getSelectedRows();
            this.editItem(item);
            this.selectTableRows(selectedRows);
            ItemGroupPanel.scrollToRow(this.table, selectedRows[0]);
        }
    }

    private void scrollToTop() {
        if (this.table.getRowCount() > 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(0, 0, false));
        }
    }

    private void selectTableRows(int[] selectedRows) {
        this.table.clearSelection();
        int[] nArray = selectedRows;
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            this.table.getSelectionModel().addSelectionInterval(row, row);
            ++n2;
        }
    }

    private void editItem(ClipboardItem item) {
        if (item instanceof TextClipboardItem) {
            this.editTextItem((TextClipboardItem)item);
        } else {
            this.editImageItem((ImageClipboardItem)item);
        }
    }

    private void editImageItem(ImageClipboardItem item) {
        Boolean imageNameEdited = ImageItemDialog.showDialog(item, true);
        if (imageNameEdited != null && imageNameEdited.booleanValue()) {
            this.getSelectedGroup().itemsChanged();
        }
    }

    private void editTextItem(TextClipboardItem item) {
        ClipboardItem newItem = NamedItemEditDialog.showDialog(item);
        if (newItem != null) {
            this.replaceItem(item, newItem);
        }
    }

    private void replaceItem(ClipboardItem itemToBeReplaced, ClipboardItem newItem) {
        ItemGroup group = this.getSelectedGroup();
        if (group != null) {
            group.replaceItem(itemToBeReplaced, newItem);
        }
    }

    @Override
    public ClipboardItem getSelectedItem() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (!selectedItems.isEmpty()) {
            return selectedItems.get(0);
        }
        return null;
    }

    private List<ClipboardItem> getSelectedItems() {
        int[] selectedRows;
        ArrayList<ClipboardItem> result = new ArrayList<ClipboardItem>();
        int[] nArray = selectedRows = this.table.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            result.add(this.namedItemsModel.getItemAt(this.table.convertRowIndexToModel(rowIndex)));
            ++n2;
        }
        return result;
    }

    private ActionListener createMitNewActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemGroupPanel.this.createNewItem();
            }
        };
    }

    @Override
    public void createNewItem() {
        ClipboardItem newItem = NamedItemEditDialog.showDialog(null);
        if (newItem != null) {
            this.addNewItem(newItem);
        }
    }

    private void addNewItem(ClipboardItem item) {
        ItemGroup group = this.getSelectedGroup();
        if (group != null) {
            group.addOrMoveItemToTop(item);
        }
    }

    public void selectGroup(String name) {
        this.itemGroupComboPanel.selectGroup(name);
        this.tablePanel.clearFilter();
    }

    private void initComponents() {
        this.itemGroupSelectionChanged();
        this.setMitCreateNewEnabledState();
    }

    private void setMitCreateNewEnabledState() {
        this.actionsMenuHolder.getMiNew().setEnabled(!ItemGroupHolder.getInstance().getItemGroups().isEmpty());
    }

    public void itemGroupSelectionChanged() {
        ItemGroup selectedItemGroup = this.getSelectedGroup();
        if (selectedItemGroup != null) {
            this.namedItemsModel.setData(this.getSelectedGroup().getItems());
            this.selectFirstRow();
        } else {
            this.namedItemsModel.setData(new ArrayList<ClipboardItem>());
        }
    }

    private ItemGroup getSelectedGroup() {
        NamedItemGroup selectedGroup = this.itemGroupComboPanel.getSelectedNamedGroup();
        if (selectedGroup != null) {
            return selectedGroup.getItemGroup();
        }
        return null;
    }

    private void createComponents() {
        this.createTable();
        this.createItemGroupComboPanel();
    }

    private void createItemGroupComboPanel() {
        this.itemGroupComboPanel = new ItemGroupComboPanel(this);
    }

    private void createTable() {
        this.table = new JTable();
        this.namedItemsModel = new NamedItemsModel();
        this.table.setModel(this.namedItemsModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(2);
        this.tablePanel = this.createTablePanel();
    }

    private TablePanel<NamedItemsModel> createTablePanel() {
        return new TablePanelBuilder(this.table).setFilterFieldLabelText("Name:").setFilterFieldLabelMnemonic(69).setPopupMenusHolder(this.createTablePanelPopupMenusHolder()).setActionsButtonMnemonic(65).build();
    }

    private TablePanelPopupMenusHolder createTablePanelPopupMenusHolder() {
        this.actionsMenuHolder = new ItemGroupPanelActionsMenuHolder();
        this.addItemsActions(this.actionsMenuHolder);
        this.actionsMenuHolder.setTableSelectionDependentMenuItemsEnabled(false);
        ItemGroupPanelActionsMenuHolder contenxtMenuActionsMenuHolder = new ItemGroupPanelActionsMenuHolder();
        this.addItemsActions(contenxtMenuActionsMenuHolder);
        return this.createTablePanelPopupMenusHolder(this.actionsMenuHolder.getPopupMenu(), contenxtMenuActionsMenuHolder.getPopupMenu());
    }

    private TablePanelPopupMenusHolder createTablePanelPopupMenusHolder(final JPopupMenu actionsMenu, final JPopupMenu contextMenu) {
        return new TablePanelPopupMenusHolder(){

            @Override
            public JPopupMenu getContextMenu() {
                return contextMenu;
            }

            @Override
            public JPopupMenu getActionsMenu() {
                return actionsMenu;
            }
        };
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        if (!MyPreferences.INSTANCE.isGroupComboBoxHidden()) {
            this.addItemsGroupPanel();
        }
        this.addItemsPanel();
    }

    private void addItemsGroupPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(3, 0, 10, 0);
        this.add((Component)this.itemGroupComboPanel, c);
    }

    private void addItemsPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add(this.tablePanel, c);
    }

    @Override
    public void panelDisplayed() {
        this.tablePanel.focusFilterField();
    }

    public void clearFilter() {
        this.tablePanel.clearFilter();
        this.selectFirstRow();
    }

    @Override
    public void moveSelectedToTop() {
        ClipboardItem selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            this.getSelectedGroup().moveExistingItemToTop(selectedItem);
        }
    }

    @Override
    public void selectNext() {
        ItemGroupPanel.moveSelection(this.table, 1);
    }

    @Override
    public void selectPrevious() {
        ItemGroupPanel.moveSelection(this.table, -1);
    }

    public void selectDefaultRowIfSelectionIsCleared() {
        if (this.table.getSelectedRow() < 0) {
            this.selectFirstRow();
        }
    }

    public void setGroupComboBoxVisible(boolean visible) {
        if (visible) {
            this.addItemsGroupPanel();
        } else {
            this.remove(this.itemGroupComboPanel);
        }
        this.validate();
    }

    @Override
    public void moveItemUp() {
        ClipboardItem clipboardItem = this.getSelectedItem();
        if (clipboardItem == null) {
            return;
        }
        this.getSelectedGroup().moveUp(clipboardItem);
        this.selectClipboardItem(clipboardItem);
    }

    private void selectClipboardItem(ClipboardItem clipboardItem) {
        int row = this.table.convertRowIndexToView(this.getModelRow(clipboardItem));
        this.table.getSelectionModel().setSelectionInterval(row, row);
        ItemGroupPanel.scrollToRow(this.table, row);
    }

    private int getModelRow(ClipboardItem clipboardItem) {
        int i = 0;
        while (i < this.namedItemsModel.getRowCount()) {
            if (this.namedItemsModel.getData().get(i) == clipboardItem) {
                return i;
            }
            ++i;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void moveItemDown() {
        ClipboardItem clipboardItem = this.getSelectedItem();
        if (clipboardItem == null) {
            return;
        }
        this.getSelectedGroup().moveDown(clipboardItem);
        this.selectClipboardItem(clipboardItem);
    }
}

