/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class Key {
    private final int modifiers;
    private final int keyCode;

    public Key(int modifiers, int keyCode) {
        this.modifiers = modifiers;
        this.keyCode = keyCode;
    }

    public String toText() {
        String result = "";
        if (this.modifiers != 0) {
            result = String.valueOf(result) + KeyEvent.getKeyModifiersText(this.modifiers) + "+";
        }
        return String.valueOf(result) + KeyEvent.getKeyText(this.keyCode);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(this.getKeyCode(), this.getModifiers());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.keyCode;
        result = 31 * result + this.modifiers;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        if (this.keyCode != other.keyCode) {
            return false;
        }
        return this.modifiers == other.modifiers;
    }
}

