/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kb.ClipboardChangeListener;
import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.ClipboardManager;
import kb.PreferencesPersistor;
import kb.clipboard.ClipboardAcessor;
import kb.gui.ContentPreviewPanel;
import kb.gui.DialogClosingCommand;
import kb.gui.DialogClosingCommandsExecutor;
import kb.gui.DividerLocationCalculator;
import kb.gui.ItemGroupPanel;
import kb.gui.MainFrameButtonsPanel;
import kb.gui.MainFrameMenuBarHolder;
import kb.gui.MainFramePanel;
import kb.gui.MainPanel;
import kb.gui.OkComponentPopupMenuHolder;
import kb.gui.PreviewAreaPosition;
import kb.gui.ShortcutKeyItem;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.Size;
import kb.gui.search.SearchPanel;
import kb.gui.toolbar.ToolbarHandler;
import kb.gui.utils.MyTabComponent;
import kb.utils.Observable;
import kb.utils.Observer;
import kb.utils.Utils;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static MainFrame INSTANCE;
    private MainFrameMenuBarHolder menuBarHolder;
    private MainPanel mainPanel;
    private ItemGroupPanel itemGroupPanel;
    private SearchPanel searchPanel;
    private MyTabComponent searchTabComponent;
    private JTabbedPane tabbedPane;
    private ContentPreviewPanel contentPreviewPanel;
    private MainFrameButtonsPanel buttonsPanel;
    private OkComponentPopupMenuHolder okComponentPopupMenuHolder;
    private MainFramePanel beforeSearchSelectedPanel;
    private MainFramePanel selectedPanel;
    private JSplitPane splitPane;
    private DividerLocationCalculator dividerLocationCalculator;
    private boolean dividerVertical;
    private ChangeListener tabbedPaneChangeListener;
    private boolean tabsVisible;
    private Component toolbarPanel;
    private List<JDialog> dialogs = new ArrayList<JDialog>();
    private Map<Observer<?>, Observable<?>> observersMap = new HashMap();

    private MainFrame() {
    }

    private void init() {
        this.initFromPrefs();
        this.createComponents();
        this.addComponents();
        this.initSplitPaneDividerLocation();
        this.initWindow();
        this.addActions();
        this.initContentPreviewArea();
    }

    private void initSplitPaneDividerLocation() {
        this.dividerLocationCalculator.initDividerLocation();
    }

    private void initContentPreviewArea() {
        this.contentPreviewPanel.setContent(this.selectedPanel.getSelectedItem());
    }

    private void initFromPrefs() {
        this.tabsVisible = !MyPreferences.INSTANCE.areTabsHidden();
        this.dividerVertical = this.isDividerVertical(MyPreferences.INSTANCE.getPreviewAreaPosition());
    }

    private boolean isDividerVertical(PreviewAreaPosition previewAreaPosition) {
        return previewAreaPosition == PreviewAreaPosition.BOTTOM || previewAreaPosition == PreviewAreaPosition.TOP;
    }

    public static void reinitMainFrame() {
        INSTANCE.hideFrame();
        DialogClosingCommandsExecutor.INSTANCE.removeAllCommands();
        MainFrame.INSTANCE.searchPanel.stopSearch();
        INSTANCE.removeObservers();
        INSTANCE.disposeRegisteredDialogs();
        INSTANCE.dispose();
        MainFrame.initInstance();
        ShortcutKeyItem.reinitUIRelatedShortcuts();
        INSTANCE.showFrame();
    }

    private void removeObservers() {
        for (Observer<?> observer : this.observersMap.keySet()) {
            this.observersMap.get(observer).removeObserver(observer);
        }
    }

    private void disposeRegisteredDialogs() {
        for (JDialog dialog : this.dialogs) {
            dialog.dispose();
        }
    }

    private void addActions() {
        this.addApprovalObserver(this.mainPanel);
        this.addSelectionObserver(this.mainPanel);
        this.addApprovalObserver(this.itemGroupPanel);
        this.addSelectionObserver(this.itemGroupPanel);
        this.addApprovalObserver(this.searchPanel);
        this.addSelectionObserver(this.searchPanel);
        this.addButtonsActions();
        this.dividerLocationCalculator.addActions();
        this.addFrameClosingCommands();
    }

    private void addFrameClosingCommands() {
        DialogClosingCommandsExecutor.INSTANCE.addCommand(this.createFrameClosingCommand());
    }

    private DialogClosingCommand createFrameClosingCommand() {
        return new DialogClosingCommand(){

            @Override
            public void execute() {
                MainFrame.this.executeFrameClosingCommand();
            }
        };
    }

    private void executeFrameClosingCommand() {
        if (this.getExtendedState() == 0) {
            this.executeFrameResizeCommand();
            this.executeDividerLocationChangeCommand();
        }
    }

    private void executeDividerLocationChangeCommand() {
        int newDividerLocation;
        int oldDividerLocation = MyPreferences.INSTANCE.getDividerLocation();
        if (oldDividerLocation != (newDividerLocation = this.splitPane.getDividerLocation())) {
            MyPreferences.INSTANCE.setDividerLocation(newDividerLocation);
            new PreferencesPersistor().storeToDisk();
        }
    }

    private void executeFrameResizeCommand() {
        Size newMainFrameSize;
        Size oldMainFrameSize = MyPreferences.INSTANCE.getMainFrameSize();
        if (!oldMainFrameSize.equals(newMainFrameSize = new Size(this.getWidth(), this.getHeight()))) {
            MyPreferences.INSTANCE.setMainFrameSize(newMainFrameSize);
            new PreferencesPersistor().storeToDisk();
        }
    }

    private void addSelectionObserver(final MainFramePanel mainFramePanel) {
        mainFramePanel.getSelectionObservable().addObserver(new Observer<ClipboardItem>(){

            @Override
            public void update(ClipboardItem clipboardItem) {
                if (MainFrame.this.selectedPanel == mainFramePanel) {
                    MainFrame.this.contentPreviewPanel.setContent(clipboardItem);
                }
            }
        });
    }

    private void addTabbedPaneChangeListener() {
        this.tabbedPaneChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.tabbedPaneChanged();
            }
        };
        this.tabbedPane.addChangeListener(this.tabbedPaneChangeListener);
    }

    private void tabbedPaneChanged() {
        this.selectedPanel = (MainFramePanel)this.tabbedPane.getSelectedComponent();
        this.selectedPanelChanged();
    }

    private void addButtonsActions() {
        this.buttonsPanel.getBtnCancel().addActionListener(this.createButtonCancelActionListener());
        this.buttonsPanel.getBtnOk().addActionListener(this.createButtonOkActionListener());
        this.buttonsPanel.getOkComponent().getArrow().setMnemonic(68);
    }

    private ActionListener createButtonOkActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.itemChosen();
            }
        };
    }

    private ActionListener createButtonCancelActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.hideFrame();
            }
        };
    }

    private void addApprovalObserver(MainFramePanel mainFramePanel) {
        mainFramePanel.getApprovalObservable().addObserver(new Observer<ClipboardContent>(){

            @Override
            public void update(ClipboardContent data) {
                MainFrame.this.itemChosen();
            }
        });
    }

    private void itemChosen() {
        ClipboardContent selectedClipboardItemContent = this.selectedPanel.getSelectedClipboardItemContent();
        if (selectedClipboardItemContent != null) {
            this.hideFrame();
            this.executePasteMode(selectedClipboardItemContent);
            this.executeSelectionMode();
            if (this.selectedPanel != this.mainPanel) {
                ClipboardManager.getInstance().clipboardChanged(selectedClipboardItemContent);
            }
        }
    }

    private void executePasteMode(ClipboardContent selectedClipboardItemContent) {
        if (this.okComponentPopupMenuHolder.getPasteMode() == OkComponentPopupMenuHolder.PasteMode.PUT_IN_CLIPBOARD) {
            ClipboardAcessor.writeToClipboard(selectedClipboardItemContent);
        } else {
            ClipboardAcessor.writeToClipboardAndPaste(selectedClipboardItemContent);
        }
    }

    private void executeSelectionMode() {
        switch (this.okComponentPopupMenuHolder.getSelectionMode()) {
            case MOVE_TO_TOP: {
                this.selectedPanel.moveSelectedToTop();
                break;
            }
            case SELECT_NEXT: {
                this.selectedPanel.selectNext();
                break;
            }
            case SELECT_PREVIOUS: {
                this.selectedPanel.selectPrevious();
            }
        }
    }

    public void registerEscapeKey() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "myEscape");
    }

    private void registerEscapeAction() {
        this.getRootPane().getActionMap().put("myEscape", this.createEscapeAction());
    }

    private AbstractAction createEscapeAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.hideFrame();
            }
        };
    }

    public void unregisterEscapeKey() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), null);
    }

    private void initWindow() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Keepboard");
        this.setIconImage(Utils.getImage("myIcon.JPG"));
        this.addWindowListener(this.getWindowClosingListener());
        this.setSize();
        this.setLocation();
        this.registerEscapeAction();
        this.registerEscapeKey();
    }

    private void setSize() {
        Size size = MyPreferences.INSTANCE.getMainFrameSize();
        this.setSize(size.getWidth(), size.getHeight());
    }

    private void setLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    private WindowListener getWindowClosingListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.hideFrame();
            }
        };
    }

    private void createComponents() {
        this.mainPanel = new MainPanel(this);
        this.itemGroupPanel = new ItemGroupPanel();
        this.searchPanel = new SearchPanel();
        this.searchTabComponent = new MyTabComponent("Search", 82, this.createSearchPanelCloseActionListener());
        this.menuBarHolder = new MainFrameMenuBarHolder();
        this.tabbedPane = new JTabbedPane();
        this.contentPreviewPanel = new ContentPreviewPanel();
        this.buttonsPanel = new MainFrameButtonsPanel(this.createOkComponentPopupMenu());
        this.selectedPanel = this.mainPanel;
        this.createSplitPane();
        this.dividerLocationCalculator = new DividerLocationCalculator(this.splitPane);
        this.toolbarPanel = ToolbarHandler.getInstance().getToolbarPanel();
        if (this.tabsVisible) {
            this.addTabbedPaneComponents();
        }
    }

    private void addTabbedPaneComponents() {
        this.tabbedPane.addTab("Clipboard history", this.mainPanel);
        this.tabbedPane.addTab("Saved items", this.itemGroupPanel);
        this.tabbedPane.setMnemonicAt(0, 67);
        this.tabbedPane.setMnemonicAt(1, 86);
        this.addTabbedPaneChangeListener();
    }

    private ActionListener createSearchPanelCloseActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.searchPanel.stopSearch();
                boolean wasSearchPanelSelected = MainFrame.this.tabbedPane.getSelectedComponent() == MainFrame.this.searchPanel;
                MainFrame.this.tabbedPane.removeTabAt(2);
                if (wasSearchPanelSelected) {
                    MainFrame.this.setSelectedPanel(MainFrame.this.beforeSearchSelectedPanel);
                }
            }
        };
    }

    private JPopupMenu createOkComponentPopupMenu() {
        this.okComponentPopupMenuHolder = new OkComponentPopupMenuHolder();
        return this.okComponentPopupMenuHolder.getPopupMenu();
    }

    public void hideFrame() {
        this.setExtendedState(0);
        DialogClosingCommandsExecutor.INSTANCE.executeCommands();
        this.setVisible(false);
    }

    private void addComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        if (!MyPreferences.INSTANCE.isToolbarHidden()) {
            this.addToolbar();
        }
        this.addSplitPane();
        this.addMenu();
        if (!MyPreferences.INSTANCE.areButtonsHidden()) {
            this.addButtonsPanel();
        }
    }

    private void addToolbar() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 17;
        this.add(this.toolbarPanel, c);
    }

    private void addButtonsPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.buttonsPanel, c);
    }

    private void addSplitPane() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.getContentPane().add((Component)this.splitPane, c);
    }

    private void createSplitPane() {
        this.splitPane = new JSplitPane();
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.initSplitPane(MyPreferences.INSTANCE.getPreviewAreaPosition());
    }

    private void initSplitPane(PreviewAreaPosition previewAreaPosition) {
        JComponent secondComponent;
        JComponent firstComponent;
        JComponent itemsPanel;
        int orientation = previewAreaPosition == PreviewAreaPosition.TOP || previewAreaPosition == PreviewAreaPosition.BOTTOM ? 0 : 1;
        JComponent jComponent = itemsPanel = this.tabsVisible ? this.tabbedPane : this.mainPanel;
        if (previewAreaPosition == PreviewAreaPosition.TOP || previewAreaPosition == PreviewAreaPosition.LEFT) {
            firstComponent = this.contentPreviewPanel;
            secondComponent = itemsPanel;
        } else {
            firstComponent = itemsPanel;
            secondComponent = this.contentPreviewPanel;
        }
        this.splitPane.setLeftComponent(null);
        this.splitPane.setRightComponent(null);
        this.splitPane.setOrientation(orientation);
        this.splitPane.setLeftComponent(firstComponent);
        this.splitPane.setRightComponent(secondComponent);
    }

    private void addMenu() {
        this.setJMenuBar(this.menuBarHolder.createAndInitMenuBar());
    }

    public void showFrame() {
        this.setVisible(false);
        this.adjustFilterAndSelectionState();
        this.setVisible(true);
        this.selectedPanel.panelDisplayed();
    }

    private void adjustFilterAndSelectionState() {
        if (this.okComponentPopupMenuHolder.getSelectionMode() == OkComponentPopupMenuHolder.SelectionMode.MOVE_TO_TOP) {
            this.mainPanel.clearFilter();
            this.itemGroupPanel.clearFilter();
        } else {
            this.mainPanel.selectDefaultRowIfSelectionIsCleared();
            this.itemGroupPanel.selectDefaultRowIfSelectionIsCleared();
        }
    }

    public void displayErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    public boolean displayConfirmationMessage(String message) {
        return JOptionPane.showConfirmDialog(this, message, "Confirmation", 0) == 0;
    }

    public static void initInstance() {
        INSTANCE = new MainFrame();
        INSTANCE.init();
    }

    public static MainFrame getInstance() {
        return INSTANCE;
    }

    public void continueClipboardChangeTracking() {
        ClipboardChangeListener.getInstance().continueListening();
        this.menuBarHolder.clipboardChangeTrackingContinued();
    }

    public void pauseClipboardChangeTracking() {
        ClipboardChangeListener.getInstance().pauseListening();
        this.menuBarHolder.clipboardChangeTrackingPaused();
    }

    public void goToItemGroup(String name) {
        this.setSelectedPanel(this.itemGroupPanel);
        this.itemGroupPanel.selectGroup(name);
    }

    private void setSelectedPanel(MainFramePanel mainFramePanel) {
        boolean wasPanelSelected = this.selectedPanel == mainFramePanel;
        this.selectedPanel = mainFramePanel;
        if (this.tabsVisible) {
            this.tabbedPane.setSelectedComponent(this.selectedPanel);
            if (wasPanelSelected) {
                this.selectedPanel.panelDisplayed();
            }
        } else {
            this.setItemsComponentInSplitPane(this.selectedPanel);
            this.validate();
            this.selectedPanelChanged();
            this.dividerLocationCalculator.setDividerLocation();
        }
    }

    private void selectedPanelChanged() {
        this.selectedPanel.panelDisplayed();
        this.contentPreviewPanel.setContent(this.selectedPanel.getSelectedItem());
    }

    public void goToClipboardHistory() {
        this.setSelectedPanel(this.mainPanel);
    }

    public MainFrameMenuBarHolder getMenuBarHolder() {
        return this.menuBarHolder;
    }

    public void registerDialog(JDialog dialog) {
        this.dialogs.add(dialog);
    }

    public void registerObserver(Observer<?> observer, Observable<?> observable) {
        this.observersMap.put(observer, observable);
    }

    public void showSearchPane() {
        if (this.tabsVisible && this.tabbedPane.getTabCount() < 3) {
            this.addSearchTab();
        }
        if (this.selectedPanel != this.searchPanel) {
            this.beforeSearchSelectedPanel = this.selectedPanel;
        }
        this.setSelectedPanel(this.searchPanel);
    }

    private void addSearchTab() {
        this.tabbedPane.addTab("", this.searchPanel);
        this.tabbedPane.setTabComponentAt(2, this.searchTabComponent);
        this.tabbedPane.setMnemonicAt(2, 82);
    }

    public void setTabsVisible(boolean tabsVisible) {
        if (this.tabsVisible == tabsVisible) {
            return;
        }
        DialogClosingCommandsExecutor.INSTANCE.executeCommands();
        this.tabsVisible = tabsVisible;
        if (tabsVisible) {
            this.setItemsComponentInSplitPane(this.tabbedPane);
            this.addTabbedPaneComponents();
            if (this.selectedPanel == this.searchPanel) {
                this.addSearchTab();
            }
            this.validate();
            this.dividerLocationCalculator.setDividerLocation();
        } else {
            this.tabbedPane.removeChangeListener(this.tabbedPaneChangeListener);
            this.tabbedPane.removeAll();
        }
        this.setSelectedPanel(this.selectedPanel);
    }

    private void setItemsComponentInSplitPane(Component itemsComponent) {
        PreviewAreaPosition previewAreaPosition = MyPreferences.INSTANCE.getPreviewAreaPosition();
        if (previewAreaPosition == PreviewAreaPosition.RIGHT || previewAreaPosition == PreviewAreaPosition.BOTTOM) {
            this.splitPane.setLeftComponent(itemsComponent);
        } else {
            this.splitPane.setRightComponent(itemsComponent);
        }
    }

    public void setButtonsVisible(boolean buttonsVisible) {
        DialogClosingCommandsExecutor.INSTANCE.executeCommands();
        if (buttonsVisible) {
            this.addButtonsPanel();
        } else {
            this.remove(this.buttonsPanel);
        }
        this.validate();
        this.dividerLocationCalculator.setDividerLocationAfterButtonsVisibilityChange(buttonsVisible);
    }

    public void setGroupComboBoxVisible(boolean visible) {
        this.itemGroupPanel.setGroupComboBoxVisible(visible);
    }

    public void showItemsGroupPanel() {
        this.setSelectedPanel(this.itemGroupPanel);
    }

    public void moveSelectedItemUp() {
        this.selectedPanel.moveItemUp();
    }

    public void moveSelectedItemDown() {
        this.selectedPanel.moveItemDown();
    }

    public void copySelectedItemsToGroup() {
        this.selectedPanel.copySelectedItemsToGroup();
    }

    public void deleteSelectedItems() {
        this.selectedPanel.deleteSelectedItems();
    }

    public void openSelectedItem() {
        this.selectedPanel.openSelectedItem();
    }

    public void createNewItem() {
        this.selectedPanel.createNewItem();
    }

    public void setToolbarVisible(boolean visible) {
        DialogClosingCommandsExecutor.INSTANCE.executeCommands();
        if (visible) {
            this.addToolbar();
        } else {
            this.remove(this.toolbarPanel);
        }
        this.validate();
        this.dividerLocationCalculator.setDividerLocationAfterToolbarVisibilityChange(visible);
    }

    public void setPreviewAreaPosition(PreviewAreaPosition previewAreaPosition) {
        int contentAreaWidth = this.contentPreviewPanel.getWidth();
        this.initSplitPane(previewAreaPosition);
        if (this.dividerVertical && !this.isDividerVertical(previewAreaPosition)) {
            this.setSize(this.getWidth() + 400, this.getHeight());
        } else if (!this.dividerVertical && this.isDividerVertical(previewAreaPosition)) {
            this.setSize(this.getWidth() - contentAreaWidth, this.getHeight());
        }
        this.dividerVertical = this.isDividerVertical(previewAreaPosition);
        this.contentPreviewPanel.adjustLineWrapCheckBoxVisibility();
        this.validate();
        this.dividerLocationCalculator.setDividerLocationAfterPreviewAreaPositionChange();
    }
}

