/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import kb.gui.ExitActionListener;
import kb.gui.PopupMenuUtils;
import kb.gui.PreviewAreaPosition;
import kb.gui.SystemTrayHandler;
import kb.gui.listeners.AboutActionListener;
import kb.gui.listeners.EmptyClipboardActionListener;
import kb.gui.listeners.GoToClipboardHistoryActionListener;
import kb.gui.listeners.GoToItemGroupActionListener;
import kb.gui.listeners.PauseActionListener;
import kb.gui.listeners.PreferencesActionListener;
import kb.gui.listeners.PreviewAreaPositionActionListener;
import kb.gui.listeners.SaveClipboardContentActionListener;
import kb.gui.listeners.SearchActionListener;
import kb.gui.listeners.ShortcutKeysActionListener;
import kb.gui.listeners.ShowButtonsActionListener;
import kb.gui.listeners.ShowGroupComboBoxActionListener;
import kb.gui.listeners.ShowSystemTrayIconActionListener;
import kb.gui.listeners.ShowTabsActionListener;
import kb.gui.listeners.ShowToolbarActionListener;
import kb.gui.listeners.ViewGroupsPanelActionListener;
import kb.gui.listeners.WhatsNewActionListener;
import kb.gui.prefs.MyPreferences;

public class MainFrameMenuBarHolder {
    private JMenuItem pauseClipboardTrackingMenuItem;
    private JMenuItem saveClipboardContentMenuItem;
    private JMenuItem emptyClipboardMenuItem;
    private JMenuItem goToItemGroupMenuItem;
    private JMenuItem goToClipboardHistoryMenuItem;
    private JMenuItem viewItemGroupPanelMenuItem;
    private JMenuItem shortcutKeysMenuItem;
    private JMenuItem preferencesMenuItem;
    private JMenuItem searchMenuItem;

    public JMenuBar createAndInitMenuBar() {
        JMenuBar result = this.createMenuBar();
        this.disablePausedStateMenuItems();
        return result;
    }

    private void disablePausedStateMenuItems() {
        this.setPausedStateMenuItemsEnabled(false);
    }

    private void enablePausedStateMenuItems() {
        this.setPausedStateMenuItemsEnabled(true);
    }

    private void setPausedStateMenuItemsEnabled(boolean enabled) {
        this.saveClipboardContentMenuItem.setEnabled(enabled);
    }

    public JMenuItem getGoToItemGroupMenuItem() {
        return this.goToItemGroupMenuItem;
    }

    public JMenuItem getGoToClipboardHistoryMenuItem() {
        return this.goToClipboardHistoryMenuItem;
    }

    public JMenuItem getEmptyClipboardMenuItem() {
        return this.emptyClipboardMenuItem;
    }

    public JMenuItem getSaveClipboardContentMenuItem() {
        return this.saveClipboardContentMenuItem;
    }

    public JMenuItem getPauseClipboardTrackingMenuItem() {
        return this.pauseClipboardTrackingMenuItem;
    }

    private JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        result.add(this.createClipboardMenu());
        result.add(this.createViewMenu());
        result.add(this.createItemsGroupMenu());
        result.add(this.createToolsMenu());
        result.add(this.createHelpMenu());
        return result;
    }

    private JMenu createViewMenu() {
        JMenu result = new JMenu("View");
        result.setMnemonic(87);
        result.add(this.createPreviewAreaPositionMenu());
        result.addSeparator();
        result.add(this.createShowTabsMenu());
        result.add(this.createShowButtonsMenu());
        result.add(this.createShowGroupComboMenu());
        result.add(this.createShowToolbarMenu());
        result.add(this.createShowSystemTrayIconMenu());
        PopupMenuUtils.addGlobalPopupMenuListener(result.getPopupMenu());
        return result;
    }

    private JMenu createPreviewAreaPositionMenu() {
        JMenu result = new JMenu("Preview area location");
        ButtonGroup buttonGroup = new ButtonGroup();
        result.add(this.createPreviewAreaPositionMenuItem("Top", PreviewAreaPosition.TOP, buttonGroup));
        result.add(this.createPreviewAreaPositionMenuItem("Left", PreviewAreaPosition.LEFT, buttonGroup));
        result.add(this.createPreviewAreaPositionMenuItem("Bottom", PreviewAreaPosition.BOTTOM, buttonGroup));
        result.add(this.createPreviewAreaPositionMenuItem("Right", PreviewAreaPosition.RIGHT, buttonGroup));
        return result;
    }

    private JMenuItem createPreviewAreaPositionMenuItem(String text, PreviewAreaPosition previewAreaPosition, ButtonGroup buttonGroup) {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem(text);
        buttonGroup.add(result);
        result.setSelected(MyPreferences.INSTANCE.getPreviewAreaPosition() == previewAreaPosition);
        result.addActionListener(new PreviewAreaPositionActionListener(previewAreaPosition));
        return result;
    }

    private JMenuItem createShowSystemTrayIconMenu() {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem("Show icon in system tray");
        result.setSelected(!MyPreferences.INSTANCE.isTrayIconHidden());
        result.setEnabled(SystemTrayHandler.getInstance().isSystemTraySupported());
        result.addActionListener(new ShowSystemTrayIconActionListener(result));
        return result;
    }

    private JMenuItem createShowToolbarMenu() {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem("Show toolbar");
        result.setSelected(!MyPreferences.INSTANCE.isToolbarHidden());
        result.addActionListener(new ShowToolbarActionListener(result));
        return result;
    }

    private JMenuItem createShowTabsMenu() {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem("Show tabs");
        result.setSelected(!MyPreferences.INSTANCE.areTabsHidden());
        result.addActionListener(new ShowTabsActionListener(result));
        return result;
    }

    private JMenuItem createShowButtonsMenu() {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem("Show main frame buttons");
        result.setSelected(!MyPreferences.INSTANCE.areButtonsHidden());
        result.addActionListener(new ShowButtonsActionListener(result));
        return result;
    }

    private JMenuItem createShowGroupComboMenu() {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem("Show group drop-down list");
        result.setSelected(!MyPreferences.INSTANCE.isGroupComboBoxHidden());
        result.addActionListener(new ShowGroupComboBoxActionListener(result));
        return result;
    }

    private JMenu createToolsMenu() {
        JMenu result = new JMenu("Tools");
        result.setMnemonic(84);
        this.shortcutKeysMenuItem = this.createKeyShortcutsMenu();
        result.add(this.shortcutKeysMenuItem);
        this.preferencesMenuItem = this.createPreferencesMenu();
        result.add(this.preferencesMenuItem);
        this.searchMenuItem = this.createSearchMenu();
        result.add(this.searchMenuItem);
        PopupMenuUtils.addGlobalPopupMenuListener(result.getPopupMenu());
        return result;
    }

    private JMenuItem createSearchMenu() {
        JMenuItem result = new JMenuItem("Search...");
        result.addActionListener(new SearchActionListener());
        return result;
    }

    private JMenuItem createPreferencesMenu() {
        JMenuItem result = new JMenuItem("Preferences...");
        result.addActionListener(new PreferencesActionListener());
        return result;
    }

    private JMenuItem createKeyShortcutsMenu() {
        JMenuItem result = new JMenuItem("Shortcut keys...");
        result.addActionListener(new ShortcutKeysActionListener());
        return result;
    }

    private JMenu createHelpMenu() {
        JMenu result = new JMenu("Help");
        result.setMnemonic(72);
        result.add(this.createWhatsNewMenu());
        result.add(this.createAboutMenu());
        PopupMenuUtils.addGlobalPopupMenuListener(result.getPopupMenu());
        return result;
    }

    private JMenuItem createWhatsNewMenu() {
        JMenuItem result = new JMenuItem("What's new?");
        result.addActionListener(new WhatsNewActionListener());
        return result;
    }

    private JMenuItem createAboutMenu() {
        JMenuItem result = new JMenuItem("About Keepboard...");
        result.addActionListener(new AboutActionListener());
        return result;
    }

    private JMenu createClipboardMenu() {
        JMenu result = new JMenu("Clipboard");
        result.setMnemonic(80);
        this.pauseClipboardTrackingMenuItem = this.createPauseClipboardTrackingMenuItem();
        result.add(this.pauseClipboardTrackingMenuItem);
        this.emptyClipboardMenuItem = this.createEmptyClipboardMenuItem();
        result.add(this.emptyClipboardMenuItem);
        this.saveClipboardContentMenuItem = this.createSaveClipboardContentMenuItem();
        result.add(this.saveClipboardContentMenuItem);
        result.addSeparator();
        result.add(this.crateExitMenuItem());
        PopupMenuUtils.addGlobalPopupMenuListener(result.getPopupMenu());
        return result;
    }

    private JMenuItem crateExitMenuItem() {
        JMenuItem result = new JMenuItem("Exit");
        result.addActionListener(new ExitActionListener());
        return result;
    }

    private JMenu createItemsGroupMenu() {
        JMenu result = new JMenu("Saved items");
        result.setMnemonic(83);
        this.goToItemGroupMenuItem = this.createGoToItemGroupMenuItem();
        result.add(this.goToItemGroupMenuItem);
        result.addSeparator();
        this.goToClipboardHistoryMenuItem = this.createGoToClipboardHistoryMenuItem();
        result.add(this.goToClipboardHistoryMenuItem);
        this.viewItemGroupPanelMenuItem = this.viewItemGroupPanelMenuItem();
        result.add(this.viewItemGroupPanelMenuItem);
        PopupMenuUtils.addGlobalPopupMenuListener(result.getPopupMenu());
        return result;
    }

    private JMenuItem viewItemGroupPanelMenuItem() {
        JMenuItem result = new JMenuItem("View groups panel");
        result.addActionListener(new ViewGroupsPanelActionListener());
        return result;
    }

    private JMenuItem createGoToClipboardHistoryMenuItem() {
        JMenuItem result = new JMenuItem("View clipboard history panel");
        result.addActionListener(new GoToClipboardHistoryActionListener());
        return result;
    }

    private JMenuItem createGoToItemGroupMenuItem() {
        JMenuItem result = new JMenuItem("View group...");
        result.addActionListener(new GoToItemGroupActionListener());
        return result;
    }

    private JMenuItem createPauseClipboardTrackingMenuItem() {
        JMenuItem result = new JMenuItem("Pause clipboard tracking");
        result.addActionListener(new PauseActionListener());
        return result;
    }

    private JMenuItem createEmptyClipboardMenuItem() {
        JMenuItem result = new JMenuItem("Clear current clipboard content");
        result.addActionListener(new EmptyClipboardActionListener());
        return result;
    }

    private JMenuItem createSaveClipboardContentMenuItem() {
        JMenuItem result = new JMenuItem("Save current clipboard content");
        result.addActionListener(new SaveClipboardContentActionListener());
        return result;
    }

    public void clipboardChangeTrackingContinued() {
        this.disablePausedStateMenuItems();
        this.pauseClipboardTrackingMenuItem.setText("Pause clipboard tracking");
    }

    public void clipboardChangeTrackingPaused() {
        this.enablePausedStateMenuItems();
        this.pauseClipboardTrackingMenuItem.setText("Continue clipboard tracking");
    }

    public JMenuItem getShortcutKeysMenuItem() {
        return this.shortcutKeysMenuItem;
    }

    public JMenuItem getPreferencesMenuItem() {
        return this.preferencesMenuItem;
    }

    public JMenuItem getSearchMenuItem() {
        return this.searchMenuItem;
    }

    public JMenuItem getViewItemGroupPanelMenuItem() {
        return this.viewItemGroupPanelMenuItem;
    }
}

