/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.ImageClipboardItem;
import kb.ItemGroup;
import kb.ItemGroupHolder;
import kb.TextClipboardItem;
import kb.gui.ClipboardHistoryItemEditDialog;
import kb.gui.ImageItemDialog;
import kb.gui.ItemGroupChooser;
import kb.gui.ItemsModel;
import kb.gui.MainFrame;
import kb.gui.MainFramePanel;
import kb.gui.MainPanelActionsMenuHolder;
import kb.gui.MainPanelActionsMenusHolders;
import kb.gui.utils.TablePanel;
import kb.gui.utils.TablePanelBuilder;
import kb.gui.utils.TablePanelPopupMenusHolder;
import kb.utils.Observer;

class MainPanel
extends MainFramePanel {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_NAMED_ITEM_LENGTH = 20;
    private MainFrame mainFrame;
    private JTable table;
    private ItemsModel model;
    private TablePanel<ItemsModel> tablePanel;
    private MainPanelActionsMenusHolders actionsMenuHolders;
    private ItemGroup clipboardHistory;

    public MainPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.clipboardHistory = ItemGroupHolder.getInstance().getClipboardHistory();
        this.createComponents();
        this.addComponents();
        this.addActions();
        this.clipboardItemGroupChanged(this.clipboardHistory.getItems());
    }

    @Override
    public ClipboardContent getSelectedClipboardItemContent() {
        ClipboardItem result = this.getSelectedItem();
        if (result != null) {
            return result.getContent();
        }
        return null;
    }

    @Override
    public ClipboardItem getSelectedItem() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (!selectedItems.isEmpty()) {
            return selectedItems.get(0);
        }
        return null;
    }

    private void addActions() {
        this.addClipboardHistoryObserver();
        this.addTableApprovalObserver();
        this.addTableDeleteObserver();
        this.addTableSelectionListener();
    }

    private void addTableDeleteObserver() {
        this.tablePanel.getDeleteObservable().addObserver(new Observer<int[]>(){

            @Override
            public void update(int[] data) {
                MainPanel.this.deleteSelectedItems();
            }
        });
    }

    private void addTableSelectionListener() {
        this.table.getSelectionModel().addListSelectionListener(this.crateTableSelectionListener());
    }

    private ListSelectionListener crateTableSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MainPanel.this.actionsMenuHolders.setTableSelectionDependentItemsEnabled(MainPanel.this.isAnyTableRowSelected());
                MainPanel.this.getSelectionObservable().updateObservers(MainPanel.this.getSelectedItem());
            }
        };
    }

    private boolean isAnyTableRowSelected() {
        return this.table.getSelectedRow() >= 0;
    }

    private void addTableApprovalObserver() {
        this.tablePanel.getApprovalObservable().addObserver(new Observer<Integer>(){

            @Override
            public void update(Integer data) {
                MainPanel.this.getApprovalObservable().updateObservers(MainPanel.this.getSelectedClipboardItemContent());
            }
        });
    }

    private void addClipboardHistoryObserver() {
        Observer<List<ClipboardItem>> observer = this.createObserver();
        this.clipboardHistory.getObservable().addObserver(observer);
        MainFrame.getInstance().registerObserver(observer, this.clipboardHistory.getObservable());
    }

    private Observer<List<ClipboardItem>> createObserver() {
        return new Observer<List<ClipboardItem>>(){

            @Override
            public void update(List<ClipboardItem> data) {
                MainPanel.this.clipboardItemGroupChanged(data);
            }
        };
    }

    private void createComponents() {
        this.createTable();
    }

    private void createTable() {
        this.table = new JTable();
        this.model = new ItemsModel();
        this.table.setModel(this.model);
        this.table.setTableHeader(null);
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.tablePanel = this.createTablePanel();
        this.add(this.tablePanel, c);
    }

    private TablePanel<ItemsModel> createTablePanel() {
        return new TablePanelBuilder(this.table).setFilterFieldLabelText("Item:").setFilterFieldLabelMnemonic(69).setPopupMenusHolder(this.createTablePanelPopupMenuHolder()).setActionsButtonMnemonic(65).build();
    }

    private TablePanelPopupMenusHolder createTablePanelPopupMenuHolder() {
        this.actionsMenuHolders = new MainPanelActionsMenusHolders();
        this.addActionsMenusActions(this.actionsMenuHolders.getActionButtonMenus());
        this.addActionsMenusActions(this.actionsMenuHolders.getContextMenuMenus());
        this.actionsMenuHolders.setTableSelectionDependentItemsEnabled(false);
        return this.createTablePanelPopupMenuHolder(this.actionsMenuHolders.getActionButtonMenus().getPopupMenu(), this.actionsMenuHolders.getContextMenuMenus().getPopupMenu());
    }

    private void addActionsMenusActions(MainPanelActionsMenuHolder actionsMenuHolder) {
        actionsMenuHolder.getMiCopy().addActionListener(this.createCopyToItemGroupActionListener());
        actionsMenuHolder.getMiNew().addActionListener(this.createMiNewActionListener());
        actionsMenuHolder.getMiEdit().addActionListener(this.createEditActionListener());
        actionsMenuHolder.getMiDelete().addActionListener(this.createDeleteActionListener());
    }

    private ActionListener createMiNewActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainPanel.this.createNewItem();
            }
        };
    }

    private TablePanelPopupMenusHolder createTablePanelPopupMenuHolder(final JPopupMenu actionsMenu, final JPopupMenu contextMenu) {
        return new TablePanelPopupMenusHolder(){

            @Override
            public JPopupMenu getContextMenu() {
                return contextMenu;
            }

            @Override
            public JPopupMenu getActionsMenu() {
                return actionsMenu;
            }
        };
    }

    private ActionListener createEditActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainPanel.this.openSelectedItem();
            }
        };
    }

    @Override
    public void openSelectedItem() {
        ClipboardItem item = this.getSelectedItem();
        if (item != null) {
            int[] selectedRows = this.table.getSelectedRows();
            this.editItem(item);
            this.selectTableRows(selectedRows);
            MainPanel.scrollToRow(this.table, selectedRows[0]);
        }
    }

    private void selectTableRows(int[] selectedRows) {
        this.table.clearSelection();
        int[] nArray = selectedRows;
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            this.table.getSelectionModel().addSelectionInterval(row, row);
            ++n2;
        }
    }

    private void editItem(ClipboardItem item) {
        if (item instanceof TextClipboardItem) {
            this.editTextItem((TextClipboardItem)item);
        } else {
            this.editImageItem((ImageClipboardItem)item);
        }
    }

    private void editImageItem(ImageClipboardItem item) {
        ImageItemDialog.showDialog(item, false);
    }

    private void editTextItem(TextClipboardItem item) {
        TextClipboardItem newItem = ClipboardHistoryItemEditDialog.showDialog(item);
        if (newItem != null) {
            this.clipboardHistory.replaceItem(item, newItem);
        }
    }

    private ActionListener createDeleteActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainPanel.this.deleteSelectedItems();
            }
        };
    }

    @Override
    public void deleteSelectedItems() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (selectedItems != null && !selectedItems.isEmpty()) {
            this.deleteItemsIfConfirmed(selectedItems);
        }
    }

    private void deleteItemsIfConfirmed(List<ClipboardItem> items) {
        if (this.mainFrame.displayConfirmationMessage("Delete selected items?")) {
            this.deleteItems(items);
        }
    }

    private void deleteItems(List<ClipboardItem> items) {
        for (ClipboardItem clipboardItem : items) {
            this.clipboardHistory.deleteItem(clipboardItem);
        }
    }

    private ActionListener createCopyToItemGroupActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainPanel.this.copySelectedItemsToGroup();
            }
        };
    }

    @Override
    public void copySelectedItemsToGroup() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (selectedItems != null && !selectedItems.isEmpty()) {
            this.copyItemsToGroup(selectedItems);
        }
    }

    private void copyItemsToGroup(List<ClipboardItem> selectedItems) {
        String groupName = ItemGroupChooser.showDialog("Copy items to group");
        if (groupName != null && !groupName.isEmpty()) {
            this.copyItemsToGroup(selectedItems, groupName);
        }
    }

    private void copyItemsToGroup(List<ClipboardItem> selectedItems, String groupName) {
        ItemGroup itemGroup = ItemGroupHolder.getInstance().getItemGroup(groupName);
        Collections.reverse(selectedItems);
        for (ClipboardItem clipboardItem : selectedItems) {
            itemGroup.addOrMoveItemToTop(this.createNamedItem(clipboardItem));
        }
    }

    private ClipboardItem createNamedItem(ClipboardItem clipboardItem) {
        ClipboardItem result = clipboardItem.createClonedInstance();
        result.setName(this.getClipboardItemName(clipboardItem));
        return result;
    }

    private String getClipboardItemName(ClipboardItem clipboardItem) {
        String name = clipboardItem instanceof TextClipboardItem ? ((TextClipboardItem)clipboardItem).getContent().getText().replaceAll("\\s+", " ").trim() : "<image>";
        return name.length() > 20 ? name.substring(0, 20).trim() : name;
    }

    private List<ClipboardItem> getSelectedItems() {
        int[] selectedRows;
        ArrayList<ClipboardItem> result = new ArrayList<ClipboardItem>();
        int[] nArray = selectedRows = this.table.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            result.add(this.model.getItemAt(this.table.convertRowIndexToModel(rowIndex)));
            ++n2;
        }
        return result;
    }

    private void clipboardItemGroupChanged(List<ClipboardItem> items) {
        this.model.setData(items);
        this.selectDefaultPasteRow();
    }

    public void selectDefaultPasteRow() {
        this.doSelectDefaultPasteRow();
        this.scrollToTop();
    }

    private void doSelectDefaultPasteRow() {
        if (this.table.getRowCount() > 0) {
            if (this.table.getRowCount() == 1) {
                this.table.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                this.table.getSelectionModel().setSelectionInterval(1, 1);
            }
        }
    }

    private void scrollToTop() {
        if (this.table.getRowCount() > 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(0, 0, false));
        }
    }

    public void clearFilter() {
        this.tablePanel.clearFilter();
        this.selectDefaultPasteRow();
    }

    @Override
    public void panelDisplayed() {
        this.tablePanel.focusFilterField();
    }

    @Override
    public void moveSelectedToTop() {
        ClipboardItem selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            this.clipboardHistory.moveExistingItemToTop(selectedItem);
        }
    }

    @Override
    public void selectNext() {
        MainPanel.moveSelection(this.table, 1);
    }

    @Override
    public void selectPrevious() {
        MainPanel.moveSelection(this.table, -1);
    }

    public void selectDefaultRowIfSelectionIsCleared() {
        if (this.table.getSelectedRow() < 0) {
            this.selectDefaultPasteRow();
        }
    }

    @Override
    public void moveItemUp() {
        ClipboardItem clipboardItem = this.getSelectedItem();
        if (clipboardItem == null) {
            return;
        }
        this.clipboardHistory.moveUp(clipboardItem);
        this.selectClipboardItem(clipboardItem);
    }

    private void selectClipboardItem(ClipboardItem clipboardItem) {
        int row = this.table.convertRowIndexToView(this.getModelRow(clipboardItem));
        this.table.getSelectionModel().setSelectionInterval(row, row);
        MainPanel.scrollToRow(this.table, row);
    }

    private int getModelRow(ClipboardItem clipboardItem) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            if (this.model.getData().get(i) == clipboardItem) {
                return i;
            }
            ++i;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void moveItemDown() {
        ClipboardItem clipboardItem = this.getSelectedItem();
        if (clipboardItem == null) {
            return;
        }
        this.clipboardHistory.moveDown(clipboardItem);
        this.selectClipboardItem(clipboardItem);
    }

    @Override
    public void createNewItem() {
        TextClipboardItem newItem = ClipboardHistoryItemEditDialog.showDialog(null);
        if (newItem != null) {
            this.clipboardHistory.addOrMoveItemToTop(newItem);
        }
    }
}

