/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import kb.gui.GuiUtils;
import kb.gui.MainFrame;
import kb.gui.platf.PlatformDependentLayoutFactory;

public abstract class MyInputDialog<T>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private T value;
    private JPanel buttonsPanel;
    private JButton okButton;
    private JButton cancelButton;
    protected boolean disposed;

    protected MyInputDialog() {
        super(MainFrame.getInstance());
        this.setModal(true);
        this.createComponents();
        this.addActions();
        this.setDefaultButton();
        MainFrame.getInstance().registerDialog(this);
    }

    @Override
    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    private void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.okButton);
    }

    protected final void addDialogComponents() {
        this.addComponents();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(visible);
    }

    protected final void clearValue() {
        this.value = null;
    }

    protected JButton getOkButton() {
        return this.okButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    private void createComponents() {
        this.buttonsPanel = this.createButtonsPanel();
    }

    private JPanel createButtonsPanel() {
        JPanel result = new JPanel();
        this.okButton = this.createOkButton();
        this.cancelButton = this.createCancelButton();
        PlatformDependentLayoutFactory.getInstance().getOKCancelLayout(result, this.okButton, this.cancelButton).layoutButtons();
        return result;
    }

    private JButton createOkButton() {
        JButton result = new JButton("OK");
        GuiUtils.setSize(result, new Dimension(100, 30));
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyInputDialog.this.inputConfirmed();
            }
        });
        return result;
    }

    protected void inputConfirmed() {
        this.value = this.getValue();
        this.setVisible(false);
    }

    protected abstract T getValue();

    private JButton createCancelButton() {
        JButton result = new JButton("Cancel");
        GuiUtils.setSize(result, new Dimension(100, 30));
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyInputDialog.this.setVisible(false);
            }
        });
        return result;
    }

    protected abstract JPanel getValuePanel();

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addValuePanel();
        this.addButtonsPanel();
    }

    private void addValuePanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.getValuePanel(), c);
    }

    private void addButtonsPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.buttonsPanel, c);
    }

    private void addActions() {
        this.registerEscapeKey();
    }

    private void registerEscapeKey() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "myEscape");
        this.getRootPane().getActionMap().put("myEscape", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MyInputDialog.this.setVisible(false);
            }
        });
    }

    public final T getInputValue() {
        return this.value;
    }
}

