/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kb.ClipboardItem;
import kb.PreferencesPersistor;
import kb.TextClipboardContent;
import kb.TextClipboardItem;
import kb.gui.DialogClosingCommand;
import kb.gui.DialogClosingCommandsExecutor;
import kb.gui.MyInputDialog;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.Size;
import kb.gui.utils.TextAreaComponent;

public class NamedItemEditDialog
extends MyInputDialog<ClipboardItem> {
    private static final long serialVersionUID = 1L;
    private static NamedItemEditDialog INSTANCE;
    private JPanel valuePanel;
    private JTextField txtName;
    private TextAreaComponent textAreaComponent;
    private ClipboardItem itemToEdit;
    private String itemToEditContent;

    private NamedItemEditDialog() {
        this.createAndAddComponents();
        DialogClosingCommandsExecutor.INSTANCE.addCommand(this.createDialogClosingCommand());
    }

    private DialogClosingCommand createDialogClosingCommand() {
        return new DialogClosingCommand(){

            @Override
            public void execute() {
                NamedItemEditDialog.this.executeLineWrapCommand();
                NamedItemEditDialog.this.executeDialogResizeCommand();
            }
        };
    }

    private void executeLineWrapCommand() {
        boolean newValue;
        boolean oldValue = MyPreferences.INSTANCE.isNamedItemsPreviewDialogLineWrap();
        if (oldValue != (newValue = this.textAreaComponent.isLineWrap())) {
            MyPreferences.INSTANCE.setNamedItemsPreviewDialogLineWrap(newValue);
            new PreferencesPersistor().storeToDisk();
        }
    }

    private void executeDialogResizeCommand() {
        Size newSize;
        Size oldSize = MyPreferences.INSTANCE.getNamedItemsPreviewDialogSize();
        if (!oldSize.equals(newSize = new Size(this.getWidth(), this.getHeight()))) {
            MyPreferences.INSTANCE.setNamedItemsPreviewDialogSize(newSize);
            new PreferencesPersistor().storeToDisk();
        }
    }

    public static ClipboardItem showDialog(ClipboardItem itemToEdit) {
        NamedItemEditDialog.createInstanceIfNotCreated();
        INSTANCE.clearValue();
        INSTANCE.setItemToEdit(itemToEdit);
        INSTANCE.setVisible(true);
        return (ClipboardItem)INSTANCE.getInputValue();
    }

    private void setItemToEdit(ClipboardItem itemToEdit) {
        this.itemToEdit = itemToEdit;
        this.itemToEditContent = itemToEdit != null ? ((TextClipboardContent)itemToEdit.getContent()).getText() : null;
        this.setTitle(itemToEdit == null ? "New named item" : "Edit named item");
        this.initComponents();
        this.checkButtonOkEnabledState();
    }

    private static void createInstanceIfNotCreated() {
        if (INSTANCE == null || NamedItemEditDialog.INSTANCE.disposed) {
            INSTANCE = new NamedItemEditDialog();
        }
    }

    private void createAndAddComponents() {
        this.valuePanel = this.createValuePanel();
        this.addDialogComponents();
        this.addActions();
        Size size = MyPreferences.INSTANCE.getNamedItemsPreviewDialogSize();
        this.setSize(size.getWidth(), size.getHeight());
    }

    private void addActions() {
        this.txtName.getDocument().addDocumentListener(this.createDocumentListener());
        this.textAreaComponent.getTextArea().getDocument().addDocumentListener(this.createDocumentListener());
        this.txtName.addFocusListener(this.createTxtNameFocusListener());
    }

    private FocusListener createTxtNameFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                NamedItemEditDialog.this.txtName.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                NamedItemEditDialog.this.txtName.select(0, 0);
            }
        };
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NamedItemEditDialog.this.checkButtonOkEnabledState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NamedItemEditDialog.this.checkButtonOkEnabledState();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        };
    }

    private void checkButtonOkEnabledState() {
        this.getOkButton().setEnabled(!this.isNameEmpty() && !this.isItemContentEmpty() && this.isAnythingChanged());
    }

    private boolean isNameEmpty() {
        return this.txtName.getText().trim().isEmpty();
    }

    private boolean isItemContentEmpty() {
        return this.textAreaComponent.getText().trim().isEmpty();
    }

    private boolean isAnythingChanged() {
        return this.itemToEdit == null || !this.itemToEditContent.equals(this.textAreaComponent.getText()) || !this.itemToEdit.getName().equals(this.txtName.getText());
    }

    private JPanel createValuePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        this.createAndAddNameField(result);
        this.createAndAddItemField(result);
        this.textAreaComponent.setLineWrap(MyPreferences.INSTANCE.isNamedItemsPreviewDialogLineWrap());
        return result;
    }

    private void initComponents() {
        if (this.itemToEdit != null) {
            this.txtName.setText(this.itemToEdit.getName());
            this.textAreaComponent.setText(this.itemToEditContent);
            this.adjustTxaItemScrollbars();
        } else {
            this.txtName.setText("");
            this.textAreaComponent.setText("");
        }
        this.txtName.requestFocusInWindow();
    }

    private void adjustTxaItemScrollbars() {
        this.textAreaComponent.getTextArea().setCaretPosition(0);
    }

    private void createAndAddNameField(JPanel result) {
        this.txtName = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)this.createTxtNameLabel(), c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        result.add((Component)this.txtName, c);
    }

    private JLabel createTxtNameLabel() {
        JLabel result = new JLabel("Name: ");
        result.setLabelFor(this.txtName);
        result.setDisplayedMnemonic(69);
        return result;
    }

    private void createAndAddItemField(JPanel result) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 2;
        c.insets = new Insets(7, 0, 0, 0);
        this.textAreaComponent = new TextAreaComponent();
        result.add(this.textAreaComponent.getComponent(), c);
    }

    @Override
    protected ClipboardItem getValue() {
        return this.createValue();
    }

    private ClipboardItem createValue() {
        TextClipboardItem result = new TextClipboardItem(this.textAreaComponent.getText());
        result.setName(this.txtName.getText().trim());
        return result;
    }

    @Override
    protected JPanel getValuePanel() {
        return this.valuePanel;
    }
}

