/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kb.PreferencesPersistor;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.OkActionPref;

public class OkComponentPopupMenuHolder {
    private JPopupMenu popupMenu;
    private List<MyMenuItem> menuItems = new ArrayList<MyMenuItem>();
    private PasteMode pasteMode;
    private SelectionMode selectionMode;

    public OkComponentPopupMenuHolder() {
        this.createPopupMenu();
        this.initState();
    }

    private void initState() {
        OkActionPref pref = MyPreferences.INSTANCE.getOkActionPref();
        this.pasteMode = pref.getPasteMode();
        this.selectionMode = pref.getSelectionMode();
        for (MyMenuItem menuItem : this.menuItems) {
            if (menuItem.getPasteMode() != this.pasteMode || menuItem.getSelectionMode() != this.selectionMode) continue;
            menuItem.setSelected(true);
            break;
        }
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createMyMenuItem("Paste and move to top", PasteMode.PASTE, SelectionMode.MOVE_TO_TOP));
        this.popupMenu.add(this.createMyMenuItem("Paste and select next", PasteMode.PASTE, SelectionMode.SELECT_NEXT));
        this.popupMenu.add(this.createMyMenuItem("Paste and select previous", PasteMode.PASTE, SelectionMode.SELECT_PREVIOUS));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createMyMenuItem("Put in clipboard and move to top", PasteMode.PUT_IN_CLIPBOARD, SelectionMode.MOVE_TO_TOP));
        this.popupMenu.add(this.createMyMenuItem("Put in clipboard and select next", PasteMode.PUT_IN_CLIPBOARD, SelectionMode.SELECT_NEXT));
        this.popupMenu.add(this.createMyMenuItem("Put in clipboard and select previous", PasteMode.PUT_IN_CLIPBOARD, SelectionMode.SELECT_PREVIOUS));
    }

    private JMenuItem createMyMenuItem(String text, PasteMode pasteMode, SelectionMode selectionMode) {
        final MyMenuItem result = new MyMenuItem(pasteMode, selectionMode);
        result.setText(text);
        this.menuItems.add(result);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OkComponentPopupMenuHolder.this.selectionPerformed(result);
            }
        });
        return result;
    }

    private void selectionPerformed(MyMenuItem menuItem) {
        this.pasteMode = menuItem.getPasteMode();
        this.selectionMode = menuItem.getSelectionMode();
        Iterator<MyMenuItem> iterator = this.menuItems.iterator();
        while (iterator.hasNext()) {
            JCheckBoxMenuItem checkBoxMenuItem;
            checkBoxMenuItem.setSelected((checkBoxMenuItem = (JCheckBoxMenuItem)iterator.next()) == menuItem);
        }
        MyPreferences.INSTANCE.setOkActionPref(new OkActionPref(this.pasteMode, this.selectionMode));
        new PreferencesPersistor().storeToDisk();
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public PasteMode getPasteMode() {
        return this.pasteMode;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    private static class MyMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private PasteMode pasteMode;
        private SelectionMode selectionMode;

        public MyMenuItem(PasteMode pasteMode, SelectionMode selectionMode) {
            this.pasteMode = pasteMode;
            this.selectionMode = selectionMode;
        }

        public PasteMode getPasteMode() {
            return this.pasteMode;
        }

        public SelectionMode getSelectionMode() {
            return this.selectionMode;
        }
    }

    public static enum PasteMode {
        PASTE,
        PUT_IN_CLIPBOARD;

    }

    public static enum SelectionMode {
        MOVE_TO_TOP,
        SELECT_NEXT,
        SELECT_PREVIOUS;

    }
}

