/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import kb.ActivationHotKeyHandler;
import kb.gui.Key;
import kb.gui.MainFrame;
import kb.gui.MainFrameMenuBarHolder;
import kb.gui.ShortcutKeyCategory;
import kb.gui.toolbar.ToolbarButton;
import kb.gui.toolbar.ToolbarHandler;
import kb.utils.ObjectIO;

public enum ShortcutKeyItem {
    DISPLAY_MAIN_FRAME(ShortcutKeyCategory.APPLICATION, "Show Keepboard"),
    SWITCH_TO_GROUP(ShortcutKeyCategory.SAVED_ITEMS_MENU, "View group"),
    SWITCH_TO_CLIPBOARD_HISTORY(ShortcutKeyCategory.SAVED_ITEMS_MENU, "View clipboard history panel"),
    VIEW_ITEM_GROUP(ShortcutKeyCategory.SAVED_ITEMS_MENU, "View groups panel"),
    PAUSE_CLIPBOARD_TRACKING(ShortcutKeyCategory.CLIPBOARD_MENU, "Pause clipboard tracking"),
    EMPTY_CLIPBOARD(ShortcutKeyCategory.CLIPBOARD_MENU, "Clear current clipboard content"),
    SAVE_CLIPBOARD_CONTENT(ShortcutKeyCategory.CLIPBOARD_MENU, "Save current clipboard content"),
    SHORTCUT_KEYS(ShortcutKeyCategory.TOOLS_MENU, "Shortcut keys"),
    PREFERENCES(ShortcutKeyCategory.TOOLS_MENU, "Preferences"),
    SEARCH(ShortcutKeyCategory.TOOLS_MENU, "Search"),
    NEW_ITEM(ShortcutKeyCategory.MAIN_FRAME, "New item"),
    OPEN_SELECTED_ITEM(ShortcutKeyCategory.MAIN_FRAME, "Open selected item"),
    COPY_SELECTED_ITEMS(ShortcutKeyCategory.MAIN_FRAME, "Copy selected items to group");

    private final ShortcutKeyCategory category;
    private final String description;
    private Key shortcutKey;

    private ShortcutKeyItem(ShortcutKeyCategory category, String description) {
        this.description = description;
        this.category = category;
    }

    public Key getShortcutKey() {
        return this.shortcutKey;
    }

    public void setShortcutKey(Key shortcutKey) {
        this.shortcutKey = shortcutKey;
    }

    public String getDescription() {
        return this.description;
    }

    public ShortcutKeyCategory getCategory() {
        return this.category;
    }

    private static void persist() {
        ArrayList<XMLElement> elements = new ArrayList<XMLElement>();
        ShortcutKeyItem[] shortcutKeyItemArray = ShortcutKeyItem.values();
        int n = shortcutKeyItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShortcutKeyItem item = shortcutKeyItemArray[n2];
            if (item.getShortcutKey() != null) {
                elements.add(new XMLElement(item));
            }
            ++n2;
        }
        ShortcutKeyItem.writeToDisk(ShortcutKeyItem.createXStream().toXML(elements));
    }

    private static void writeToDisk(String xml) {
        new ObjectIO().writeText(xml, "prefs/shortcutKeys.shky");
    }

    private static XStream createXStream() {
        XStream result = new XStream();
        result.alias("item", XMLElement.class);
        return result;
    }

    public static void loadPersistedState() {
        try {
            ShortcutKeyItem.initItems(ShortcutKeyItem.readElementsFromDisk());
        }
        catch (Throwable e) {
            ShortcutKeyItem.initItems(ShortcutKeyItem.getDefaulValues());
        }
    }

    private static List<XMLElement> getDefaulValues() {
        return Arrays.asList(new XMLElement(DISPLAY_MAIN_FRAME.name(), 2, 192), new XMLElement(SWITCH_TO_GROUP.name(), 2, 49), new XMLElement(SWITCH_TO_CLIPBOARD_HISTORY.name(), 2, 81), new XMLElement(VIEW_ITEM_GROUP.name(), 2, 50), new XMLElement(SAVE_CLIPBOARD_CONTENT.name(), 2, 83), new XMLElement(SEARCH.name(), 2, 70), new XMLElement(OPEN_SELECTED_ITEM.name(), 0, 115), new XMLElement(COPY_SELECTED_ITEMS.name(), 0, 116));
    }

    private static List<XMLElement> readElementsFromDisk() {
        return (List)ShortcutKeyItem.createXStream().fromXML(new ObjectIO().readText("prefs/shortcutKeys.shky"));
    }

    private static void initItems(List<XMLElement> elements) {
        for (XMLElement element : elements) {
            ShortcutKeyItem.valueOf(element.name).setShortcutKey(new Key(element.modifiers, element.keyCode));
        }
    }

    public static void reinitAndPersist() {
        ShortcutKeyItem.reinitShortcutKeys();
        ShortcutKeyItem.persist();
    }

    public static void reinitShortcutKeys() {
        ShortcutKeyItem.reinitDisplayMainFrameShortcut();
        ShortcutKeyItem.reinitUIRelatedShortcuts();
    }

    public static void reinitUIRelatedShortcuts() {
        ShortcutKeyItem.reinitMainFrameMenuItems();
        ShortcutKeyItem.reinitToolbarButtonsShortcuts();
    }

    private static void reinitToolbarButtonsShortcuts() {
        ShortcutKeyItem.reinitToolbarButtonShortcut(ToolbarHandler.getInstance().getTbNewItem(), NEW_ITEM);
        ShortcutKeyItem.reinitToolbarButtonShortcut(ToolbarHandler.getInstance().getTbOpenItem(), OPEN_SELECTED_ITEM);
        ShortcutKeyItem.reinitToolbarButtonShortcut(ToolbarHandler.getInstance().getTbCopyItems(), COPY_SELECTED_ITEMS);
        ShortcutKeyItem.reinitToolbarButtonShortcut(ToolbarHandler.getInstance().getTbSearch(), SEARCH);
    }

    private static void reinitToolbarButtonShortcut(ToolbarButton toolbarButton, ShortcutKeyItem shortcutKeyItem) {
        Key key = shortcutKeyItem.getShortcutKey();
        if (key != null) {
            ShortcutKeyItem.getMainFrameInputMap().put(key.getKeyStroke(), ShortcutKeyItem.getActionMapKey(shortcutKeyItem));
            ShortcutKeyItem.getMainFrameActionMap().put(ShortcutKeyItem.getActionMapKey(shortcutKeyItem), toolbarButton.getAction());
            toolbarButton.setToolTipText(String.valueOf(shortcutKeyItem.getDescription()) + " (" + key.toText() + ")");
        } else {
            ShortcutKeyItem.getMainFrameActionMap().put(ShortcutKeyItem.getActionMapKey(shortcutKeyItem), null);
            toolbarButton.setToolTipText(shortcutKeyItem.getDescription());
        }
    }

    private static String getActionMapKey(ShortcutKeyItem shortcutKeyItem) {
        return "MY_" + shortcutKeyItem.name();
    }

    private static ActionMap getMainFrameActionMap() {
        return MainFrame.getInstance().getRootPane().getActionMap();
    }

    private static InputMap getMainFrameInputMap() {
        return MainFrame.getInstance().getRootPane().getInputMap(2);
    }

    private static void reinitMainFrameMenuItems() {
        MainFrameMenuBarHolder menuBarHolder = MainFrame.getInstance().getMenuBarHolder();
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getGoToItemGroupMenuItem(), SWITCH_TO_GROUP);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getGoToClipboardHistoryMenuItem(), SWITCH_TO_CLIPBOARD_HISTORY);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getViewItemGroupPanelMenuItem(), VIEW_ITEM_GROUP);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getPauseClipboardTrackingMenuItem(), PAUSE_CLIPBOARD_TRACKING);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getEmptyClipboardMenuItem(), EMPTY_CLIPBOARD);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getSaveClipboardContentMenuItem(), SAVE_CLIPBOARD_CONTENT);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getShortcutKeysMenuItem(), SHORTCUT_KEYS);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getPreferencesMenuItem(), PREFERENCES);
        ShortcutKeyItem.reinitMenuItemShortcut(menuBarHolder.getSearchMenuItem(), SEARCH);
    }

    private static void reinitDisplayMainFrameShortcut() {
        Key key = DISPLAY_MAIN_FRAME.getShortcutKey();
        if (key != null) {
            ActivationHotKeyHandler.getInstance().registerActivationHotKey(KeyStroke.getKeyStroke(key.getKeyCode(), key.getModifiers()));
        } else {
            ActivationHotKeyHandler.getInstance().registerActivationHotKey(null);
        }
    }

    private static void reinitMenuItemShortcut(JMenuItem menuItem, ShortcutKeyItem shortcutKeyItem) {
        Key key = shortcutKeyItem.getShortcutKey();
        if (key != null) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(key.getKeyCode(), key.getModifiers()));
        } else {
            menuItem.setAccelerator(null);
        }
    }

    private static class XMLElement {
        String name;
        int modifiers;
        int keyCode;

        public XMLElement(ShortcutKeyItem item) {
            this.name = item.name();
            this.modifiers = item.getShortcutKey().getModifiers();
            this.keyCode = item.getShortcutKey().getKeyCode();
        }

        public XMLElement(String name, int modifiers, int keyCode) {
            this.name = name;
            this.modifiers = modifiers;
            this.keyCode = keyCode;
        }
    }
}

