/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.util.Map;
import javax.swing.JPanel;
import kb.gui.Key;
import kb.gui.MyInputDialog;
import kb.gui.ShortcutKeyItem;
import kb.gui.ShortcutKeysPanel;
import kb.utils.Observer;
import kb.utils.Utils;

public class ShortcutKeysDialog
extends MyInputDialog<Map<ShortcutKeyItem, Key>> {
    private static final long serialVersionUID = 1L;
    private static ShortcutKeysDialog INSTANCE;
    private ShortcutKeysPanel panel;

    private ShortcutKeysDialog() {
        this.setTitle("Shortcut keys");
        this.createPanel();
        this.addActions();
        this.addDialogComponents();
        this.setSize(700, 400);
    }

    public static Map<ShortcutKeyItem, Key> showDialog() {
        ShortcutKeysDialog.createInstanceIfNotCreated();
        INSTANCE.clearValue();
        INSTANCE.init();
        INSTANCE.setVisible(true);
        return (Map)INSTANCE.getInputValue();
    }

    private void init() {
        this.panel.init();
        this.checkOkButtonEnabledState();
    }

    private static void createInstanceIfNotCreated() {
        if (INSTANCE == null || ShortcutKeysDialog.INSTANCE.disposed) {
            INSTANCE = new ShortcutKeysDialog();
        }
    }

    private void addActions() {
        this.panel.getObservable().addObserver(new Observer<Map<ShortcutKeyItem, Key>>(){

            @Override
            public void update(Map<ShortcutKeyItem, Key> data) {
                ShortcutKeysDialog.this.checkOkButtonEnabledState();
            }
        });
    }

    private void checkOkButtonEnabledState() {
        this.getOkButton().setEnabled(this.isAnythingChanged());
    }

    private boolean isAnythingChanged() {
        Map<ShortcutKeyItem, Key> keys = this.panel.getData();
        ShortcutKeyItem[] shortcutKeyItemArray = ShortcutKeyItem.values();
        int n = shortcutKeyItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShortcutKeyItem keyItem = shortcutKeyItemArray[n2];
            if (!Utils.areEqualsNullsIncluded(keys.get((Object)keyItem), keyItem.getShortcutKey())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void createPanel() {
        this.panel = new ShortcutKeysPanel();
    }

    @Override
    protected Map<ShortcutKeyItem, Key> getValue() {
        if (this.isAnythingChanged()) {
            return this.panel.getData();
        }
        return null;
    }

    @Override
    protected JPanel getValuePanel() {
        return this.panel;
    }
}

