/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import kb.gui.Key;
import kb.gui.ShortcutKeyItem;
import kb.utils.Observable;

public class ShortcutKeysPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table = new JTable();
    private Model model = new Model();
    private List<KeyItem> data;
    private Key lastPressedKey;
    private boolean lastPressedKeyForbidden;
    private Observable<Map<ShortcutKeyItem, Key>> observable = new Observable();

    public ShortcutKeysPanel() {
        this.createComponents();
        this.addComponents();
        this.addActions();
    }

    public void init() {
        this.lastPressedKey = null;
        this.lastPressedKeyForbidden = false;
        this.data = this.createDataList();
        this.model.setData(this.data);
        this.table.requestFocusInWindow();
    }

    private List<KeyItem> createDataList() {
        ArrayList<KeyItem> result = new ArrayList<KeyItem>();
        ShortcutKeyItem[] shortcutKeyItemArray = ShortcutKeyItem.values();
        int n = shortcutKeyItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShortcutKeyItem shortcutKeyItem = shortcutKeyItemArray[n2];
            result.add(new KeyItem(shortcutKeyItem));
            ++n2;
        }
        return result;
    }

    public Observable<Map<ShortcutKeyItem, Key>> getObservable() {
        return this.observable;
    }

    public Map<ShortcutKeyItem, Key> getData() {
        return this.createKeysMap();
    }

    private void createComponents() {
        this.table.setModel(this.model);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(2);
        this.table.setSelectionMode(0);
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addDescriptionLabel();
        this.addTable();
    }

    private void addTable() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)new JScrollPane(this.table), c);
    }

    private void addDescriptionLabel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)new JLabel("Type new shortcut key (Backspace or Delete to remove shortcut):"), c);
    }

    private void addActions() {
        this.addTableKeyListener();
    }

    private void addTableKeyListener() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ShortcutKeysPanel.this.lastPressedKeyForbidden = ShortcutKeysPanel.this.isForbidden(e);
                if (!ShortcutKeysPanel.this.lastPressedKeyForbidden) {
                    ShortcutKeysPanel.this.lastPressedKey = ShortcutKeysPanel.this.isShortcutKeyRemovalKey(e) ? null : new Key(e.getModifiers(), e.getKeyCode());
                }
                if (ShortcutKeysPanel.this.isFunctionKey(e)) {
                    ShortcutKeysPanel.this.tableKeyTyped();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                ShortcutKeysPanel.this.tableKeyTyped();
            }
        });
    }

    private boolean isFunctionKey(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 61440: 
            case 61441: 
            case 61442: 
            case 61443: 
            case 61444: 
            case 61445: 
            case 61446: 
            case 61447: 
            case 61448: 
            case 61449: 
            case 61450: 
            case 61451: {
                return true;
            }
        }
        return false;
    }

    private boolean isShortcutKeyRemovalKey(KeyEvent e) {
        return e.getKeyCode() == 127 || e.getKeyCode() == 8;
    }

    private void tableKeyTyped() {
        if (this.lastPressedKeyForbidden) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            KeyItem selectedItem = this.model.getItemAt(selectedRow);
            selectedItem.key = this.lastPressedKey;
            this.model.fireTableCellUpdated(selectedRow, 1);
            this.observable.updateObservers(this.createKeysMap());
        }
    }

    private Map<ShortcutKeyItem, Key> createKeysMap() {
        HashMap<ShortcutKeyItem, Key> result = new HashMap<ShortcutKeyItem, Key>();
        for (KeyItem keyItem : this.data) {
            result.put(keyItem.shortcutKeyItem, keyItem.key);
        }
        return result;
    }

    private boolean isForbidden(KeyEvent e) {
        return this.isAlreadyChosen(e) || this.isReserved(e);
    }

    private boolean isAlreadyChosen(KeyEvent e) {
        for (KeyItem keyItem : this.data) {
            if (keyItem.key == null || keyItem.key.getKeyCode() != e.getKeyCode() || keyItem.key.getModifiers() != e.getModifiers()) continue;
            return true;
        }
        return false;
    }

    private boolean isReserved(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 9: 
            case 10: {
                return true;
            }
            case 65: 
            case 67: 
            case 86: 
            case 88: {
                return e.isControlDown() && !e.isAltDown() && !e.isAltGraphDown() && !e.isShiftDown();
            }
        }
        return false;
    }

    private static class KeyItem {
        ShortcutKeyItem shortcutKeyItem;
        Key key;

        KeyItem(ShortcutKeyItem shortcutKeyItem) {
            this.shortcutKeyItem = shortcutKeyItem;
            this.key = shortcutKeyItem.getShortcutKey();
        }
    }

    private static class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int DESCRIPTION = 0;
        private static final int KEY = 1;
        private static final int CATEGORY = 2;
        private final String[] columnNames = new String[]{"Action", "Shortcut key", "Category"};
        private List<KeyItem> data;

        public void setData(List<KeyItem> data) {
            this.data = data == null ? new ArrayList(0) : data;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            KeyItem item = this.data.get(row);
            switch (column) {
                case 0: {
                    return item.shortcutKeyItem.getDescription();
                }
                case 1: {
                    return item.key == null ? null : item.key.toText();
                }
                case 2: {
                    return item.shortcutKeyItem.getCategory().getDescription();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public KeyItem getItemAt(int row) {
            return this.data.get(row);
        }
    }
}

