/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import kb.ClipboardManager;
import kb.gui.ExitActionListener;
import kb.gui.prefs.MyPreferences;
import kb.utils.Utils;

public class SystemTrayHandler {
    private static final SystemTrayHandler INSTANCE = new SystemTrayHandler();
    private TrayIcon trayIcon;
    private TrayIcon pausedTrayIcon;
    private TrayIcon selectedIcon;

    private SystemTrayHandler() {
    }

    public static SystemTrayHandler getInstance() {
        return INSTANCE;
    }

    public void showInSystemTray() {
        if (!this.isSystemTraySupported()) {
            return;
        }
        this.createAndInitTrayIcons();
        this.selectedIcon = MyPreferences.INSTANCE.isPaused() ? this.pausedTrayIcon : this.trayIcon;
        this.addSelectedIconIfVisible();
    }

    public boolean isSystemTraySupported() {
        return SystemTray.isSupported();
    }

    private void addSelectedIconIfVisible() {
        if (!MyPreferences.INSTANCE.isTrayIconHidden()) {
            this.addIconToSystemTray(this.selectedIcon);
        }
    }

    private void createAndInitTrayIcons() {
        this.trayIcon = this.createTrayIcon("myIcon.JPG", "Keepboard");
        this.pausedTrayIcon = this.createTrayIcon("myIconPaused.JPG", "Keepboard is paused.");
    }

    private TrayIcon createTrayIcon(String imageName, String tooltip) {
        TrayIcon result = new TrayIcon(Utils.getImage(imageName), tooltip);
        result.setImageAutoSize(true);
        result.setPopupMenu(this.createTrayPopupMenu());
        result.addActionListener(new ShowMainFrameActionListener());
        return result;
    }

    private void addIconToSystemTray(TrayIcon trayIcon) {
        try {
            SystemTray.getSystemTray().add(trayIcon);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    private PopupMenu createTrayPopupMenu() {
        PopupMenu result = new PopupMenu();
        result.add(this.createShowMainFrameMenuItem());
        result.addSeparator();
        result.add(this.createExitMenuItem());
        return result;
    }

    private MenuItem createShowMainFrameMenuItem() {
        MenuItem result = new MenuItem("Show Keepboard");
        result.addActionListener(new ShowMainFrameActionListener());
        return result;
    }

    private MenuItem createExitMenuItem() {
        MenuItem result = new MenuItem("Exit");
        result.addActionListener(new ExitActionListener());
        return result;
    }

    public void setTrayIcon(boolean paused) {
        if (!this.isSystemTraySupported()) {
            return;
        }
        TrayIcon trayIcon = this.selectedIcon = paused ? this.pausedTrayIcon : this.trayIcon;
        if (!MyPreferences.INSTANCE.isTrayIconHidden()) {
            this.changeTrayIcon(paused);
        }
    }

    private void changeTrayIcon(boolean paused) {
        if (paused) {
            this.changeTrayIcon(this.trayIcon, this.pausedTrayIcon);
        } else {
            this.changeTrayIcon(this.pausedTrayIcon, this.trayIcon);
        }
    }

    private void changeTrayIcon(TrayIcon oldIcon, TrayIcon newIcon) {
        SystemTray.getSystemTray().remove(oldIcon);
        this.addIconToSystemTray(newIcon);
    }

    public void setTrayIconVisible(boolean visible) {
        if (!this.isSystemTraySupported()) {
            return;
        }
        if (visible) {
            this.addIconToSystemTray(this.selectedIcon);
        } else {
            SystemTray.getSystemTray().remove(this.selectedIcon);
        }
    }

    private static class ShowMainFrameActionListener
    implements ActionListener {
        private ShowMainFrameActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ClipboardManager.getInstance().showMainFrame();
        }
    }
}

