/*
 * Decompiled with CFR 0.152.
 */
package kb.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import kb.gui.GuiUtils;
import kb.gui.MainFrame;
import kb.gui.WhatsNewContent;

public class WhatsNewDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton btnClose;

    public WhatsNewDialog() {
        super(MainFrame.getInstance(), "What's new?", true);
        this.addComponents();
        this.setDefaultCloseOperation(2);
        this.addActions();
        this.setSize(600, 400);
        this.setLocationRelativeTo(MainFrame.getInstance());
        this.setVisible(true);
    }

    private void addActions() {
        this.registerEscapeKey();
        this.addComponentListener();
    }

    private void addComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                WhatsNewDialog.this.btnClose.requestFocusInWindow();
            }
        });
    }

    private void registerEscapeKey() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "myEscape");
        this.getRootPane().getActionMap().put("myEscape", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WhatsNewDialog.this.dispose();
            }
        });
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addContentPanel();
        this.addButtonsPanel();
    }

    private void addContentPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.add(this.createContentTextArea(), c);
    }

    private Component createContentTextArea() {
        JTextArea result = new JTextArea(WhatsNewContent.getContent());
        result.setWrapStyleWord(true);
        result.setLineWrap(true);
        return new JScrollPane(result);
    }

    private void addButtonsPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 5, 5);
        c.weightx = 1.0;
        c.anchor = 13;
        this.add((Component)this.createButtonClose(), c);
    }

    private JButton createButtonClose() {
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WhatsNewDialog.this.dispose();
            }
        });
        GuiUtils.setSize(this.btnClose, new Dimension(100, 30));
        return this.btnClose;
    }
}

