/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs;

import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import kb.RobotSupport;
import kb.gui.GuiUtils;
import kb.gui.Key;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.PreferenceChangeState;
import kb.gui.prefs.PreferencePanel;

public class AutopastePreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblAutopasteKey;
    private JTextField txtAutopasteKey;
    private Key oldValue;
    private Key currentKey;

    public AutopastePreferencePanel() {
        this.addComponents();
        this.initComponents();
        this.addActions();
    }

    private void addActions() {
        this.addTxtAutopasteKeyListener();
    }

    private void updateChangeObervable() {
        this.changeObservable.updateObservers(this.isValueChanged() ? PreferenceChangeState.CHANGED : PreferenceChangeState.OLD_VALUE);
    }

    private boolean isValueChanged() {
        return !this.oldValue.equals(this.currentKey);
    }

    private void addTxtAutopasteKeyListener() {
        this.txtAutopasteKey.addKeyListener(new KeyAdapter(){
            private Key lastPressedKey;

            @Override
            public void keyPressed(KeyEvent e) {
                this.lastPressedKey = new Key(e.getModifiers(), e.getKeyCode());
            }

            @Override
            public void keyTyped(KeyEvent e) {
                AutopastePreferencePanel.this.tableKeyTyped(this.lastPressedKey);
            }
        });
    }

    private void tableKeyTyped(Key key) {
        this.currentKey = key;
        this.txtAutopasteKey.setText(key.toText());
        this.updateChangeObervable();
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addLblAutopasteKey();
        this.addTxtAutopasteKey();
    }

    private void addLblAutopasteKey() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.lblAutopasteKey = new JLabel("Auto-paste key: ");
        this.add((Component)this.lblAutopasteKey, c);
    }

    private void addTxtAutopasteKey() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        this.txtAutopasteKey = this.createTxtAutopasteKey();
        this.add((Component)this.txtAutopasteKey, c);
    }

    private JTextField createTxtAutopasteKey() {
        JTextField result = new JTextField();
        result.setEditable(false);
        GuiUtils.setSize(result, new Dimension(150, 25));
        result.setHorizontalAlignment(0);
        return result;
    }

    private void initComponents() {
        this.oldValue = MyPreferences.INSTANCE.getAutopasteKey();
        this.initComponentsState();
        this.initToolTips();
        this.checkIsAutopasteSupported();
    }

    private void initToolTips() {
        this.setAutopasteKeyToolTip("<html>This will be the key combination that Keepboard will send to currently focused<br />application after an item is chosen in auto-paste mode (<i>OK</i> button configuration<br />on main frame).</html>");
    }

    private void initComponentsState() {
        this.txtAutopasteKey.setText(this.oldValue.toText());
        this.currentKey = this.oldValue;
    }

    private void checkIsAutopasteSupported() {
        if (!RobotSupport.INSTANCE.isRobotSupported()) {
            this.setAutopasteKeyComponentsEnabled(false);
            this.setAutopasteKeyToolTip(this.getRobotNotSupportedErrorMessage());
        }
    }

    private void setAutopasteKeyToolTip(String toolTip) {
        this.lblAutopasteKey.setToolTipText(toolTip);
        this.txtAutopasteKey.setToolTipText(toolTip);
    }

    private String getRobotNotSupportedErrorMessage() {
        String result = "<html>Program cannot send paste events to other applications on this platform.";
        if (Platform.isX11()) {
            result = String.valueOf(result) + "<br />Check whether XTEST 2.2 standard extension is supported (or enabled).";
        }
        return String.valueOf(result) + "</html>";
    }

    private void setAutopasteKeyComponentsEnabled(boolean enabled) {
        this.lblAutopasteKey.setEnabled(enabled);
        this.txtAutopasteKey.setEnabled(enabled);
    }

    @Override
    public void applyChanges() {
        this.oldValue = this.currentKey;
        MyPreferences.INSTANCE.setAutopasteKey(this.currentKey);
    }

    @Override
    public void clearChanges() {
        this.txtAutopasteKey.setText(this.oldValue.toText());
        this.currentKey = this.oldValue;
        this.updateChangeObervable();
    }
}

