/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.PreferenceChangeState;
import kb.gui.prefs.PreferencePanel;

public class AutosaveImagesPreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox chkAutosave;
    private boolean oldValue;

    public AutosaveImagesPreferencePanel() {
        this.addComponents();
        this.initComponents();
        this.addActions();
        this.setTooltip();
    }

    private void setTooltip() {
        this.chkAutosave.setToolTipText("If selected, Keepboard will save images automatically after they appear in clipboard.");
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addChkAutosave();
    }

    private void addChkAutosave() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        this.chkAutosave = new JCheckBox("Save images automatically");
        this.add((Component)this.chkAutosave, c);
    }

    private void initComponents() {
        this.oldValue = MyPreferences.INSTANCE.isAutosaveImages();
        this.chkAutosave.setSelected(this.oldValue);
    }

    private void addActions() {
        this.chkAutosave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutosaveImagesPreferencePanel.this.updateChangeObservable();
            }
        });
    }

    private void updateChangeObservable() {
        this.changeObservable.updateObservers(this.isValueChanged() ? PreferenceChangeState.CHANGED : PreferenceChangeState.OLD_VALUE);
    }

    private boolean isValueChanged() {
        return this.chkAutosave.isSelected() ^ this.oldValue;
    }

    @Override
    public void applyChanges() {
        this.oldValue = this.chkAutosave.isSelected();
        MyPreferences.INSTANCE.setAutosaveImages(this.chkAutosave.isSelected());
    }

    @Override
    public void clearChanges() {
        this.chkAutosave.setSelected(this.oldValue);
        this.updateChangeObservable();
    }
}

