/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.PreferenceChangeState;
import kb.gui.prefs.PreferencePanel;
import kb.gui.prefs.platf.AutostartHandler;

public class AutostartPreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox chkAutostart;
    private boolean oldValue;

    public AutostartPreferencePanel() {
        this.addComponents();
        this.initComponents();
        this.addActions();
        this.setTooltip();
        this.checkAutostartSupported();
    }

    private void checkAutostartSupported() {
        if (!AutostartHandler.getInstance().isAutostartSupported()) {
            this.chkAutostart.setEnabled(false);
            this.chkAutostart.setToolTipText("<html>Unfortunately, Keepboard has been unable to determine how to set this option on your system.<br />If you would like Keepboard to start automatically, please add it manually to your startup programs list.</html>");
        }
    }

    private void setTooltip() {
        this.chkAutostart.setToolTipText("Start Keepboard automatically after system startup.");
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addChkAutostart();
    }

    private void addChkAutostart() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        this.chkAutostart = new JCheckBox("Start Keepboard automatically");
        this.add((Component)this.chkAutostart, c);
    }

    private void initComponents() {
        this.oldValue = MyPreferences.INSTANCE.isAutostart();
        this.chkAutostart.setSelected(this.oldValue);
    }

    private void addActions() {
        this.chkAutostart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutostartPreferencePanel.this.updateChangeObservable();
            }
        });
    }

    private void updateChangeObservable() {
        this.changeObservable.updateObservers(this.isValueChanged() ? PreferenceChangeState.CHANGED : PreferenceChangeState.OLD_VALUE);
    }

    private boolean isValueChanged() {
        return this.chkAutostart.isSelected() ^ this.oldValue;
    }

    @Override
    public void applyChanges() {
        this.oldValue = this.chkAutostart.isSelected();
        MyPreferences.INSTANCE.setAutostart(this.oldValue);
        AutostartHandler.getInstance().setAutostart(this.oldValue);
    }

    @Override
    public void clearChanges() {
        this.chkAutostart.setSelected(this.oldValue);
        this.updateChangeObservable();
    }
}

