/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import kb.LookAndFeelHandler;
import kb.gui.prefs.LookAndFeelPref;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.PreferenceChangeState;
import kb.gui.prefs.PreferencePanel;

public class LookAndFeelPreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton rbNimbus;
    private JRadioButton rbSystem;
    private JRadioButton rbMetal;
    private LookAndFeelPref oldValue;
    private Map<JRadioButton, LookAndFeelPref> map = new HashMap<JRadioButton, LookAndFeelPref>();

    public LookAndFeelPreferencePanel() {
        this.addComponents();
        this.initComponents();
        this.addActions();
        this.setToolTips();
        this.disableNimbusIfNotSupported();
    }

    private void setToolTips() {
        this.rbNimbus.setToolTipText("Nimbus look and feel.");
        this.rbSystem.setToolTipText("Native system look and feel.");
        this.rbMetal.setToolTipText("Default Java cross platform look and feel.");
    }

    private void disableNimbusIfNotSupported() {
        if (!LookAndFeelHandler.INSTANCE.isNimbusSupported()) {
            this.rbNimbus.setEnabled(false);
            this.rbNimbus.setToolTipText("<html>Nimbus look and feel is not supported.<br />Please, check whether you have Java 6 Update 10 or newer version of Java.</html>");
        }
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.rbNimbus = new JRadioButton("Nimbus");
        this.add((Component)this.rbNimbus, this.createGridBagConstraints(row++));
        this.rbSystem = new JRadioButton("System");
        this.add((Component)this.rbSystem, this.createGridBagConstraints(row++));
        this.rbMetal = new JRadioButton("Metal");
        this.add((Component)this.rbMetal, this.createGridBagConstraints(row++));
        this.addRadioButtonsToGroup();
    }

    private GridBagConstraints createGridBagConstraints(int gridy) {
        GridBagConstraints result = new GridBagConstraints();
        result.gridx = 0;
        result.gridy = gridy;
        result.weightx = 1.0;
        result.fill = 2;
        return result;
    }

    private void addRadioButtonsToGroup() {
        this.addButtonToGroup(this.rbNimbus, LookAndFeelPref.NIMBUS);
        this.addButtonToGroup(this.rbSystem, LookAndFeelPref.SYSTEM);
        this.addButtonToGroup(this.rbMetal, LookAndFeelPref.METAL);
    }

    private void addButtonToGroup(JRadioButton button, LookAndFeelPref lookAndFeelPref) {
        this.buttonGroup.add(button);
        this.map.put(button, lookAndFeelPref);
    }

    private void initComponents() {
        LookAndFeelPref currentLookAndFeel = MyPreferences.INSTANCE.getLookAndFeelPref();
        this.getButton(currentLookAndFeel).setSelected(true);
        this.oldValue = currentLookAndFeel;
    }

    private JRadioButton getButton(LookAndFeelPref lookAndFeelPref) {
        for (JRadioButton button : this.map.keySet()) {
            if (this.map.get(button) != lookAndFeelPref) continue;
            return button;
        }
        throw new NoSuchElementException();
    }

    private void addActions() {
        ActionListener selectionListener = this.createSelectionListener();
        for (JRadioButton button : this.map.keySet()) {
            button.addActionListener(selectionListener);
        }
    }

    private ActionListener createSelectionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LookAndFeelPreferencePanel.this.updateChangeObservable();
            }
        };
    }

    private void updateChangeObservable() {
        this.changeObservable.updateObservers(this.isValueChanged() ? PreferenceChangeState.CHANGED : PreferenceChangeState.OLD_VALUE);
    }

    private boolean isValueChanged() {
        return this.getCurrentValue() != this.oldValue;
    }

    private LookAndFeelPref getCurrentValue() {
        return this.map.get(this.getSelectedButton());
    }

    private JRadioButton getSelectedButton() {
        for (JRadioButton button : this.map.keySet()) {
            if (!button.isSelected()) continue;
            return button;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void applyChanges() {
        LookAndFeelPref currentValue = this.getCurrentValue();
        MyPreferences.INSTANCE.setLookAndFeelPref(currentValue);
        LookAndFeelHandler.INSTANCE.updateLookAndFeel(currentValue);
        this.oldValue = currentValue;
    }

    @Override
    public void clearChanges() {
        this.getButton(this.oldValue).setSelected(true);
        this.updateChangeObservable();
    }
}

