/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import kb.ItemGroupHolder;
import kb.gui.GuiUtils;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.PreferenceChangeState;
import kb.gui.prefs.PreferencePanel;

public class MaxHistorySizePreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblMaxHistorySize;
    private JComboBox cmbMaxHistorySize;
    private int oldValue;

    public MaxHistorySizePreferencePanel() {
        this.addComponents();
        this.initComponents();
        this.addActions();
    }

    private void addActions() {
        this.addCmbMaxHistorySizeListener();
    }

    private void updateChangeObervable() {
        this.changeObservable.updateObservers(this.isValueChanged() ? PreferenceChangeState.CHANGED : PreferenceChangeState.OLD_VALUE);
    }

    private boolean isValueChanged() {
        return this.oldValue != this.getSelectedValue();
    }

    private int getSelectedValue() {
        return (Integer)this.cmbMaxHistorySize.getSelectedItem();
    }

    private void addCmbMaxHistorySizeListener() {
        this.cmbMaxHistorySize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaxHistorySizePreferencePanel.this.updateChangeObervable();
            }
        });
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addLblMaxHistorySize();
        this.addCmbMaxHistorySize();
    }

    private void addLblMaxHistorySize() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.lblMaxHistorySize = new JLabel("Max history size: ");
        this.add((Component)this.lblMaxHistorySize, c);
    }

    private void addCmbMaxHistorySize() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        this.cmbMaxHistorySize = this.createCmbMaxHistorySize();
        this.add((Component)this.cmbMaxHistorySize, c);
    }

    private JComboBox createCmbMaxHistorySize() {
        JComboBox result = new JComboBox();
        result.setRenderer(this.createCmbMaxHistorySizeCellRenderer());
        GuiUtils.setSize(result, new Dimension(80, 25));
        return result;
    }

    private ListCellRenderer createCmbMaxHistorySizeCellRenderer() {
        DefaultListCellRenderer result = new DefaultListCellRenderer();
        result.setHorizontalAlignment(4);
        return result;
    }

    private void initComponents() {
        this.oldValue = MyPreferences.INSTANCE.getMaxHistorySize();
        this.initComponentsState();
        this.initToolTips();
    }

    private void initToolTips() {
        String tooltip = "Maximum items count kept in clipboard history.";
        this.cmbMaxHistorySize.setToolTipText(tooltip);
        this.lblMaxHistorySize.setToolTipText(tooltip);
    }

    private void initComponentsState() {
        this.addItemsToCmbMaxHistorySize();
        this.cmbMaxHistorySize.setSelectedItem(this.oldValue);
    }

    private void addItemsToCmbMaxHistorySize() {
        this.cmbMaxHistorySize.addItem(1);
        this.cmbMaxHistorySize.addItem(2);
        this.cmbMaxHistorySize.addItem(3);
        this.cmbMaxHistorySize.addItem(5);
        this.cmbMaxHistorySize.addItem(10);
        this.cmbMaxHistorySize.addItem(20);
        this.cmbMaxHistorySize.addItem(30);
        this.cmbMaxHistorySize.addItem(50);
        this.cmbMaxHistorySize.addItem(100);
        this.cmbMaxHistorySize.addItem(200);
        this.cmbMaxHistorySize.addItem(300);
        this.cmbMaxHistorySize.addItem(500);
        this.cmbMaxHistorySize.addItem(1000);
        this.cmbMaxHistorySize.addItem(2000);
        this.cmbMaxHistorySize.addItem(3000);
    }

    @Override
    public void applyChanges() {
        this.oldValue = this.getSelectedValue();
        MyPreferences.INSTANCE.setMaxHistorySize(this.oldValue);
        ItemGroupHolder.getInstance().getClipboardHistory().setMaxGroupSize(this.oldValue);
    }

    @Override
    public void clearChanges() {
        this.cmbMaxHistorySize.setSelectedItem(this.oldValue);
        this.updateChangeObervable();
    }
}

