/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kb.PreferencesPersistor;
import kb.gui.MyInputDialog;
import kb.gui.prefs.AutopastePreferencePanel;
import kb.gui.prefs.AutosaveImagesPreferencePanel;
import kb.gui.prefs.AutostartPreferencePanel;
import kb.gui.prefs.LookAndFeelPreferencePanel;
import kb.gui.prefs.MaxHistorySizePreferencePanel;
import kb.gui.prefs.PreferenceChangeState;
import kb.gui.prefs.PreferencePanel;
import kb.utils.Observer;

public class PreferencesDialog
extends MyInputDialog<Void> {
    private static final long serialVersionUID = 1L;
    private static PreferencesDialog INSTANCE;
    private List<PreferencePanel> panels = new ArrayList<PreferencePanel>();
    private Set<PreferencePanel> changedPanels = new HashSet<PreferencePanel>();
    private Set<PreferencePanel> errorPanels = new HashSet<PreferencePanel>();

    private PreferencesDialog() {
        this.setTitle("Preferences");
        this.addDialogComponents();
        this.setSize(400, 450);
        this.addActions();
    }

    private void addActions() {
        for (PreferencePanel panel : this.panels) {
            panel.getChangeObservable().addObserver(this.createChangeObservable(panel));
        }
    }

    private Observer<PreferenceChangeState> createChangeObservable(final PreferencePanel panel) {
        return new Observer<PreferenceChangeState>(){

            @Override
            public void update(PreferenceChangeState data) {
                PreferencesDialog.this.preferenceChanged(panel, data);
            }
        };
    }

    private void preferenceChanged(PreferencePanel panel, PreferenceChangeState preferenceChangeState) {
        switch (preferenceChangeState) {
            case CHANGED: {
                this.changedPanels.add(panel);
                this.errorPanels.remove(panel);
                break;
            }
            case OLD_VALUE: {
                this.changedPanels.remove(panel);
                this.errorPanels.remove(panel);
                break;
            }
            case ERROR: {
                this.errorPanels.add(panel);
                this.changedPanels.remove(panel);
            }
        }
        this.getOkButton().setEnabled(this.errorPanels.isEmpty() && !this.changedPanels.isEmpty());
    }

    public static void showDialog() {
        PreferencesDialog.createInstanceIfNotCreated();
        INSTANCE.init();
        INSTANCE.setVisible(true);
    }

    private void init() {
        this.clearChanges();
    }

    private void clearChanges() {
        for (PreferencePanel panel : this.panels) {
            panel.clearChanges();
        }
    }

    @Override
    protected void inputConfirmed() {
        this.applyChanges();
        this.persistChanges();
        super.inputConfirmed();
    }

    private void persistChanges() {
        new PreferencesPersistor().storeToDisk();
    }

    private void applyChanges() {
        for (PreferencePanel panel : this.changedPanels) {
            panel.applyChanges();
        }
    }

    private static void createInstanceIfNotCreated() {
        if (INSTANCE == null || PreferencesDialog.INSTANCE.disposed) {
            INSTANCE = new PreferencesDialog();
        }
    }

    @Override
    protected Void getValue() {
        return null;
    }

    @Override
    protected JPanel getValuePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        int row = 0;
        this.addPreferencePanel(new AutostartPreferencePanel(), result, "Auto-start", row++);
        this.addPreferencePanel(new AutosaveImagesPreferencePanel(), result, "Auto-save images", row++);
        this.addPreferencePanel(new AutopastePreferencePanel(), result, "Auto-paste", row++);
        this.addPreferencePanel(new MaxHistorySizePreferencePanel(), result, "History size", row++);
        this.addLastPreferencePanel(new LookAndFeelPreferencePanel(), result, "Look & Feel", row++);
        return result;
    }

    private void addPreferencePanel(PreferencePanel preferencePanel, JPanel toPanel, String name, int row) {
        this.panels.add(preferencePanel);
        toPanel.add((Component)preferencePanel, this.createGridBagConstraints(row));
        preferencePanel.setBorder(BorderFactory.createTitledBorder(name));
    }

    private GridBagConstraints createGridBagConstraints(int gridy) {
        GridBagConstraints result = new GridBagConstraints();
        result.gridx = 0;
        result.gridy = gridy;
        result.weightx = 1.0;
        result.fill = 2;
        return result;
    }

    private void addLastPreferencePanel(PreferencePanel preferencePanel, JPanel toPanel, String name, int row) {
        this.panels.add(preferencePanel);
        GridBagConstraints c = this.createGridBagConstraints(row);
        c.weighty = 1.0;
        c.anchor = 11;
        toPanel.add((Component)preferencePanel, c);
        preferencePanel.setBorder(BorderFactory.createTitledBorder(name));
    }
}

