/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs.platf;

import com.sun.jna.Platform;
import kb.gui.prefs.MyPreferences;
import kb.gui.prefs.platf.NotSupportedAutostartHandler;
import kb.gui.prefs.platf.WindowsAutostartHandler;
import kb.gui.prefs.platf.X11AutostartHandler;

public abstract class AutostartHandler {
    private static AutostartHandler INSTANCE;

    public abstract boolean isAutostartSupported();

    public abstract void setAutostart(boolean var1);

    public static AutostartHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = AutostartHandler.createInstance();
        }
        return INSTANCE;
    }

    public final void init() {
        boolean autostart = MyPreferences.INSTANCE.isAutostart();
        this.setAutostart(!autostart);
        this.setAutostart(autostart);
    }

    private static AutostartHandler createInstance() {
        if (Platform.isX11()) {
            return new X11AutostartHandler();
        }
        if (Platform.isWindows()) {
            return new WindowsAutostartHandler();
        }
        return new NotSupportedAutostartHandler();
    }
}

