/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs.platf;

import kb.gui.prefs.platf.AutostartHandler;
import kb.gui.prefs.platf.WinRegistry;

public class WindowsAutostartHandler
extends AutostartHandler {
    private boolean autostartSupported = this.checkAutostartSupported();

    private boolean checkAutostartSupported() {
        try {
            this.writeAutostartValue("kbtest", "kbtestv");
            this.deleteAutostartKey("kbtest");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private void writeAutostartValue(String key, String value) throws Exception {
        WinRegistry.writeStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", key, value);
    }

    private void deleteAutostartKey(String key) throws Exception {
        WinRegistry.deleteValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Run", key);
    }

    @Override
    public boolean isAutostartSupported() {
        return this.autostartSupported;
    }

    @Override
    public void setAutostart(boolean autostart) {
        try {
            this.doSetAutostart(autostart);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doSetAutostart(boolean autostart) throws Exception {
        if (autostart) {
            this.writeAutostartValue("keepboard", this.getStartFilePath());
        } else {
            this.deleteAutostartKey("keepboard");
        }
    }

    private String getStartFilePath() {
        return ("\"" + System.getProperty("user.dir") + "\\Start.VBS\"").replace('/', '\\');
    }
}

