/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs.platf;

import java.io.File;

public class X11AutostartDirectoryFinder {
    public String find() {
        String result = this.findUsing_XDG_CONFIG_HOME();
        if (result == null) {
            result = this.findUsing_XDG_CONFIG_DIRS();
        }
        if (result == null) {
            result = this.findAmongPreferenceOrderedDirectories("/etc/xdg");
        }
        return result;
    }

    private String findUsing_XDG_CONFIG_HOME() {
        String XDG_CONFIG_HOME = this.getEnvVar("XDG_CONFIG_HOME");
        if (XDG_CONFIG_HOME != null) {
            return this.findAmongPreferenceOrderedDirectories(XDG_CONFIG_HOME);
        }
        String HOME = this.getEnvVar("HOME");
        if (HOME != null) {
            return String.valueOf(HOME) + "/.config/autostart";
        }
        return null;
    }

    private String getEnvVar(String string) {
        String result = System.getenv(string);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    private String findAmongPreferenceOrderedDirectories(String ... dirs) {
        String[] stringArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String path = String.valueOf(dir) + "/autostart";
            if (this.exists(path)) {
                return path;
            }
            ++n2;
        }
        return null;
    }

    private boolean exists(String directory) {
        return new File(directory).exists();
    }

    private String findUsing_XDG_CONFIG_DIRS() {
        String variableValue = this.getEnvVar("XDG_CONFIG_DIRS");
        if (variableValue != null) {
            return this.findAmongPreferenceOrderedDirectories(variableValue.split(":"));
        }
        return null;
    }
}

