/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.prefs.platf;

import kb.gui.prefs.platf.AutostartHandler;
import kb.gui.prefs.platf.X11AutostartDirectoryFinder;
import kb.utils.ObjectIO;

public class X11AutostartHandler
extends AutostartHandler {
    private String autostartDirectory;

    public X11AutostartHandler() {
        try {
            this.autostartDirectory = new X11AutostartDirectoryFinder().find();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isAutostartSupported() {
        return this.autostartDirectory != null;
    }

    @Override
    public void setAutostart(boolean autostart) {
        if (autostart) {
            this.enableAutostart();
        } else {
            this.disableAutostart();
        }
    }

    private void enableAutostart() {
        new ObjectIO().writeText(this.getAutostartFileContent(), String.valueOf(this.autostartDirectory) + "/keepboard.desktop");
    }

    private String getAutostartFileContent() {
        String startScriptPath = this.getStartFileName();
        return "[Desktop Entry]\nType=Application\nExec=" + startScriptPath + "\n" + "Hidden=false\n" + "NoDisplay=false\n" + "Name[en_US]=keepboard\n" + "Name=" + startScriptPath + "\n";
    }

    private String getStartFileName() {
        return String.valueOf(System.getProperty("user.dir")) + "/start.sh";
    }

    private void disableAutostart() {
        new ObjectIO().delete(String.valueOf(this.autostartDirectory) + "/keepboard.desktop");
    }
}

