/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kb.gui.GuiUtils;
import kb.gui.search.SearchPanel;

public class SearchInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField txtContainingText;
    private JCheckBox chkCaseSensitive;
    private JButton btnSearch;
    private JLabel lblStatus;
    private SearchPanel searchPanel;
    private boolean searching = false;

    public SearchInputPanel(SearchPanel searchPanel) {
        this.searchPanel = searchPanel;
        this.createComponents();
        this.addComponents();
        this.addActions();
    }

    private void addActions() {
        this.txtContainingText.addFocusListener(this.createTxtContainingTextFocusListener());
        this.txtContainingText.getDocument().addDocumentListener(this.createTxtContainingTextDocumentListener());
        this.addTxtContainingTextEnterAction();
    }

    private void addTxtContainingTextEnterAction() {
        this.txtContainingText.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "myEnter");
        this.txtContainingText.getActionMap().put("myEnter", this.createEnterAction());
    }

    private AbstractAction createEnterAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchInputPanel.this.txtContainingTextEnterPressed();
            }
        };
    }

    private void txtContainingTextEnterPressed() {
        if (!this.searching && !this.txtContainingText.getText().isEmpty()) {
            this.startSearch();
            this.searching = true;
        }
    }

    private FocusListener createTxtContainingTextFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchInputPanel.this.txtContainingText.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchInputPanel.this.txtContainingText.select(0, 0);
            }
        };
    }

    private DocumentListener createTxtContainingTextDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchInputPanel.this.checkBtnSearchEnabledState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchInputPanel.this.checkBtnSearchEnabledState();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        };
    }

    private void checkBtnSearchEnabledState() {
        this.btnSearch.setEnabled(!this.txtContainingText.getText().isEmpty());
    }

    private void createComponents() {
        this.createTxtContainingText();
        this.createChkCaseSensitive();
        this.lblStatus = new JLabel();
        this.createBtnSearch();
    }

    private void createTxtContainingText() {
        this.txtContainingText = new JTextField();
        GuiUtils.setSize(this.txtContainingText, new Dimension(50, 25));
    }

    private void createChkCaseSensitive() {
        this.chkCaseSensitive = new JCheckBox("Case sensitive");
        this.chkCaseSensitive.setMnemonic(65);
    }

    private void createBtnSearch() {
        this.btnSearch = new JButton("Search");
        GuiUtils.setSize(this.btnSearch, new Dimension(85, 30));
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchInputPanel.this.btnSearchPressed();
            }
        });
        this.btnSearch.setEnabled(false);
    }

    private void btnSearchPressed() {
        if (this.searching) {
            this.searchPanel.stopSearch();
            this.btnSearch.setText("Search");
            this.lblStatus.setText("Searching stopped");
        } else {
            this.startSearch();
        }
        this.searching = !this.searching;
    }

    private void startSearch() {
        this.searchPanel.startSearch(this.txtContainingText.getText(), this.chkCaseSensitive.isSelected());
        this.btnSearch.setText("Stop");
        this.lblStatus.setText("Searching...");
    }

    public void searchingFinished(int itemsFound) {
        this.searching = false;
        this.btnSearch.setText("Search");
        this.lblStatus.setText(String.valueOf(itemsFound) + (itemsFound == 1 ? " item" : " items") + " found");
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addContainingTextLabel();
        this.addTxtContainingText();
        this.addBtnSearch();
        this.addLblStatus();
        this.addChkCaseSensitive();
    }

    private void addContainingTextLabel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.createTxtContainingTextLabel(), c);
    }

    private JLabel createTxtContainingTextLabel() {
        JLabel result = new JLabel("Containing text: ");
        result.setLabelFor(this.txtContainingText);
        result.setDisplayedMnemonic(88);
        return result;
    }

    private void addTxtContainingText() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.txtContainingText, c);
    }

    private void addBtnSearch() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.btnSearch, c);
    }

    private void addLblStatus() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.lblStatus, c);
    }

    private void addChkCaseSensitive() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 4);
        c.anchor = 13;
        this.add((Component)this.chkCaseSensitive, c);
    }

    public void focusTextField() {
        this.txtContainingText.requestFocusInWindow();
    }
}

