/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JSeparator;
import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.gui.MainFramePanel;
import kb.gui.search.SearchInputPanel;
import kb.gui.search.SearchResultItem;
import kb.gui.search.SearchResultsPanel;
import kb.gui.search.SearchWorker;

public class SearchPanel
extends MainFramePanel {
    private static final long serialVersionUID = 1L;
    private SearchInputPanel searchInputPanel;
    private SearchResultsPanel searchResultsPanel;
    private SearchWorker searchWorker;
    private int itemsFound;

    public SearchPanel() {
        this.createComponents();
        this.addComponents();
    }

    private void createComponents() {
        this.searchInputPanel = new SearchInputPanel(this);
        this.searchResultsPanel = new SearchResultsPanel(this);
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addSearchInputPanel();
        this.addSeparator();
        this.addSearchResultsPanel();
    }

    private void addSearchInputPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.searchInputPanel, c);
    }

    private void addSeparator() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 3, 5, 3);
        this.add((Component)new JSeparator(), c);
    }

    private void addSearchResultsPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.searchResultsPanel, c);
    }

    public void startSearch(String searchText, boolean caseSensitive) {
        this.itemsFound = 0;
        this.searchResultsPanel.clearResults();
        this.searchWorker = new SearchWorker(searchText, caseSensitive, this);
        this.searchWorker.search();
    }

    public void stopSearch() {
        if (this.searchWorker == null) {
            return;
        }
        this.itemsFound = 0;
        this.searchWorker.stop();
        this.searchWorker = null;
    }

    public void publishResultsPart(List<SearchResultItem> resultsPart, boolean finished) {
        this.searchResultsPanel.appendResultsPart(resultsPart);
        this.itemsFound += resultsPart.size();
        if (finished) {
            this.searchInputPanel.searchingFinished(this.itemsFound);
        }
    }

    @Override
    public void moveSelectedToTop() {
    }

    @Override
    public void selectNext() {
        SearchPanel.moveSelection(this.searchResultsPanel.getTable(), 1);
    }

    @Override
    public void selectPrevious() {
        SearchPanel.moveSelection(this.searchResultsPanel.getTable(), -1);
    }

    @Override
    public ClipboardContent getSelectedClipboardItemContent() {
        return this.searchResultsPanel.getSelectedClipboardItemContent();
    }

    @Override
    public ClipboardItem getSelectedItem() {
        return this.searchResultsPanel.getSelectedItem();
    }

    @Override
    public void panelDisplayed() {
        this.searchInputPanel.focusTextField();
    }
}

