/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.PreferencesPersistor;
import kb.gui.ActionsButtonBuilder;
import kb.gui.prefs.MyPreferences;
import kb.gui.search.SearchPanel;
import kb.gui.search.SearchResultItem;
import kb.gui.search.SearchResultsTableModel;
import kb.gui.utils.TablePanel;
import kb.gui.utils.TablePanelBuilder;
import kb.utils.Observable;
import kb.utils.Observer;

public class SearchResultsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private SearchResultsTableModel model;
    private TablePanel<SearchResultsTableModel> tablePanel;
    private TableColumn nameColumn;
    private TableColumn groupColumn;

    public SearchResultsPanel(SearchPanel searchPanel) {
        this.createComponents();
        this.addComponents();
        this.addActions(searchPanel);
    }

    private void addActions(SearchPanel searchPanel) {
        this.addTableApprovalObserver(searchPanel.getApprovalObservable());
        this.addTableSelectionListener(searchPanel.getSelectionObservable());
    }

    private void addTableApprovalObserver(final Observable<ClipboardContent> approvalObservable) {
        this.tablePanel.getApprovalObservable().addObserver(new Observer<Integer>(){

            @Override
            public void update(Integer data) {
                approvalObservable.updateObservers(SearchResultsPanel.this.getSelectedClipboardItemContent());
            }
        });
    }

    public ClipboardContent getSelectedClipboardItemContent() {
        ClipboardItem result = this.getSelectedItem();
        if (result != null) {
            return result.isDeleted() ? null : result.getContent();
        }
        return null;
    }

    public ClipboardItem getSelectedItem() {
        List<ClipboardItem> selectedItems = this.getSelectedItems();
        if (!selectedItems.isEmpty()) {
            ClipboardItem result = selectedItems.get(0);
            return result.isDeleted() ? null : result;
        }
        return null;
    }

    private List<ClipboardItem> getSelectedItems() {
        int[] selectedRows;
        ArrayList<ClipboardItem> result = new ArrayList<ClipboardItem>();
        int[] nArray = selectedRows = this.table.getSelectedRows();
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            result.add(this.model.getItemAt(this.table.convertRowIndexToModel(rowIndex)).getClipboardItem());
            ++n2;
        }
        return result;
    }

    private void addTableSelectionListener(Observable<ClipboardItem> selectionObservable) {
        this.table.getSelectionModel().addListSelectionListener(this.crateTableSelectionListener(selectionObservable));
    }

    private ListSelectionListener crateTableSelectionListener(final Observable<ClipboardItem> selectionObservable) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                selectionObservable.updateObservers(SearchResultsPanel.this.getSelectedItem());
            }
        };
    }

    private void createComponents() {
        this.createTable();
        this.adjustTableColumnsVisibility();
    }

    private void adjustTableColumnsVisibility() {
        this.nameColumn = this.table.getColumnModel().getColumn(1);
        this.groupColumn = this.table.getColumnModel().getColumn(2);
        if (!MyPreferences.INSTANCE.isShowNameSearchColumn()) {
            this.table.getColumnModel().removeColumn(this.nameColumn);
        }
        if (!MyPreferences.INSTANCE.isShowGroupSearchColumn()) {
            this.table.getColumnModel().removeColumn(this.groupColumn);
        }
    }

    private void createTable() {
        this.model = new SearchResultsTableModel();
        this.table = new JTable(this.model);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.tablePanel = new TablePanelBuilder(this.table).setFilterFieldLabelText("Item:").setFilterColumnIndex(0).setFilterFieldLabelMnemonic(69).setCustomActionsComponent(this.createColumnsButton()).build();
    }

    private Component createColumnsButton() {
        return new ActionsButtonBuilder(this.createColumnsMenu()).setText("Columns").setMnemonic(78).setSize(new Dimension(100, 25)).build();
    }

    private JPopupMenu createColumnsMenu() {
        JPopupMenu result = new JPopupMenu();
        result.add(this.createNameMenuItem());
        result.add(this.createGroupMenuItem());
        return result;
    }

    private JMenuItem createNameMenuItem() {
        final JCheckBoxMenuItem result = new JCheckBoxMenuItem("Show name");
        result.setSelected(MyPreferences.INSTANCE.isShowNameSearchColumn());
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultsPanel.this.showNameMenuActionPerformed(result.isSelected());
            }
        });
        return result;
    }

    private void showNameMenuActionPerformed(boolean selected) {
        if (selected) {
            this.table.getColumnModel().addColumn(this.nameColumn);
        } else {
            this.table.getColumnModel().removeColumn(this.nameColumn);
        }
        MyPreferences.INSTANCE.setShowNameSearchColumn(selected);
        new PreferencesPersistor().storeToDisk();
    }

    private JMenuItem createGroupMenuItem() {
        final JCheckBoxMenuItem result = new JCheckBoxMenuItem("Show group");
        result.setSelected(MyPreferences.INSTANCE.isShowGroupSearchColumn());
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultsPanel.this.showGroupMenuActionPerformed(result.isSelected());
            }
        });
        return result;
    }

    private void showGroupMenuActionPerformed(boolean selected) {
        if (selected) {
            this.table.getColumnModel().addColumn(this.groupColumn);
        } else {
            this.table.getColumnModel().removeColumn(this.groupColumn);
        }
        MyPreferences.INSTANCE.setShowGroupSearchColumn(selected);
        new PreferencesPersistor().storeToDisk();
    }

    private void addComponents() {
        this.setLayout(new GridBagLayout());
        this.addTable();
    }

    private void addTable() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add(this.tablePanel, c);
    }

    public void appendResultsPart(List<SearchResultItem> resultsPart) {
        this.model.append(resultsPart);
    }

    public void clearResults() {
        this.model.clear();
    }

    public JTable getTable() {
        return this.table;
    }
}

