/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.search;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kb.gui.search.SearchResultItem;

public class SearchResultsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int ITEM = 0;
    public static final int NAME = 1;
    public static final int GROUP = 2;
    private static final String[] columnNames = new String[]{"Item", "Name", "Group"};
    private List<SearchResultItem> items = new ArrayList<SearchResultItem>(0);

    public void append(List<SearchResultItem> items) {
        if (items.isEmpty()) {
            return;
        }
        int firstRow = this.items.size();
        this.items.addAll(items);
        this.fireTableRowsInserted(firstRow, firstRow + items.size() - 1);
    }

    public void clear() {
        this.items.clear();
        this.fireTableDataChanged();
    }

    public List<SearchResultItem> getData() {
        return this.items;
    }

    public SearchResultItem getItemAt(int rowIndex) {
        return this.items.get(rowIndex);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SearchResultItem row = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getClipboardItem().getDisplayText();
            }
            case 1: {
                return row.getClipboardItem().getName();
            }
            case 2: {
                return row.getGroupName();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }
}

