/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.search;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import kb.ClipboardItem;
import kb.ItemGroupHolder;
import kb.NamedItemGroup;
import kb.TextClipboardItem;
import kb.gui.search.SearchPanel;
import kb.gui.search.SearchResultItem;

public class SearchWorker {
    private final String searchText;
    private final boolean caseSensitive;
    private final SearchPanel searchPanel;
    private volatile boolean stopped = false;

    public SearchWorker(String searchText, boolean caseSensitive, SearchPanel searchPanel) {
        this.searchText = searchText;
        this.caseSensitive = caseSensitive;
        this.searchPanel = searchPanel;
    }

    public void search() {
        final List<Group> groups = this.getGroups();
        new Thread(){

            @Override
            public void run() {
                SearchWorker.this.doSearch(groups);
            }
        }.start();
    }

    private List<Group> getGroups() {
        ItemGroupHolder itemGroupHolder = ItemGroupHolder.getInstance();
        ArrayList<Group> result = new ArrayList<Group>();
        result.add(new Group("", itemGroupHolder.getClipboardHistory().getItems()));
        for (NamedItemGroup namedItemGroup : itemGroupHolder.getItemGroups()) {
            result.add(new Group(namedItemGroup.getName(), namedItemGroup.getItemGroup().getItems()));
        }
        return result;
    }

    private void doSearch(List<Group> groups) {
        ArrayList<SearchResultItem> resultsPart = new ArrayList<SearchResultItem>();
        for (Group group : groups) {
            for (ClipboardItem clipboardItem : group.items) {
                if (this.stopped) {
                    return;
                }
                if (this.isMatch(clipboardItem)) {
                    resultsPart.add(new SearchResultItem(clipboardItem, group.name));
                }
                if (resultsPart.isEmpty() || !this.shouldPublishImmediately(clipboardItem)) continue;
                this.publishResultsPart(resultsPart, false);
                resultsPart = new ArrayList();
            }
        }
        this.publishResultsPart(resultsPart, true);
    }

    private boolean isMatch(ClipboardItem clipboardItem) {
        if (this.isMatch(clipboardItem.getName())) {
            return true;
        }
        if (!(clipboardItem instanceof TextClipboardItem)) {
            return false;
        }
        TextClipboardItem textClipboardItem = (TextClipboardItem)clipboardItem;
        return this.isMatch(textClipboardItem.getShortText()) || this.isMatch(textClipboardItem.getContent().getText());
    }

    private boolean isMatch(String string) {
        if (string == null) {
            return false;
        }
        if (this.caseSensitive) {
            return string.indexOf(this.searchText) != -1;
        }
        return string.toUpperCase().indexOf(this.searchText.toUpperCase()) != -1;
    }

    private boolean shouldPublishImmediately(ClipboardItem clipboardItem) {
        return clipboardItem instanceof TextClipboardItem && clipboardItem.getFileName() != null;
    }

    private void publishResultsPart(final List<SearchResultItem> resultsPart, final boolean finished) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SearchWorker.this.stopped) {
                    SearchWorker.this.searchPanel.publishResultsPart(resultsPart, finished);
                }
            }
        });
    }

    public void stop() {
        this.stopped = true;
    }

    private static class Group {
        final String name;
        final List<ClipboardItem> items;

        public Group(String name, List<ClipboardItem> items) {
            this.name = name;
            this.items = items;
        }
    }
}

