/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.toolbar;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import kb.gui.GuiUtils;

public class ToolbarButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private final Dimension size = new Dimension(25, 25);

    public ToolbarButton(Icon icon, Action action, String toolTipText) {
        super(action);
        this.init();
        this.setToolTipText(toolTipText);
        this.setIcon(icon);
        GuiUtils.setSize(this, this.size);
    }

    private void init() {
        this.setFocusable(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(this.createMouseListener());
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolbarButton.this.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolbarButton.this.setContentAreaFilled(false);
            }
        };
    }
}

