/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.toolbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import kb.gui.GuiUtils;
import kb.gui.MainFrame;
import kb.gui.toolbar.ToolbarButton;
import kb.gui.toolbar.ToolbarPanel;
import kb.utils.Utils;

public class ToolbarHandler {
    private static final ToolbarHandler INSTANCE = new ToolbarHandler();
    private ToolbarButton tbNewItem;
    private ToolbarButton tbOpenItem;
    private ToolbarButton tbDeleteItems;
    private ToolbarButton tbCopyItems;
    private ToolbarButton tbMoveUp;
    private ToolbarButton tbMoveDown;
    private ToolbarButton tbSearch;
    private ToolbarPanel toolbarPanel = new ToolbarPanel();

    private ToolbarHandler() {
        this.createToolbarButtons();
        this.addToolbarButtonsToPanel();
    }

    public static ToolbarHandler getInstance() {
        return INSTANCE;
    }

    private void addToolbarButtonsToPanel() {
        this.addToolbarPanelGroup(this.tbNewItem, this.tbOpenItem, this.tbDeleteItems);
        this.addToolbarPanelGroup(this.tbCopyItems, this.tbSearch);
        this.addToolbarPanelGroup(this.tbMoveUp, this.tbMoveDown);
        this.toolbarPanel.build();
    }

    private void addToolbarPanelGroup(ToolbarButton ... buttons) {
        this.toolbarPanel.addToolbarButtonsGroup(Utils.toList(buttons));
    }

    private void createToolbarButtons() {
        this.tbNewItem = new ToolbarButton(new ImageIcon(Utils.getImage("new.png")), this.createTbNewItemAction(), "New item");
        this.tbOpenItem = new ToolbarButton(new ImageIcon(Utils.getImage("edit.png")), this.createTbOpenItemAction(), "Open selected item");
        this.tbDeleteItems = new ToolbarButton(new ImageIcon(Utils.getImage("delete.png")), this.createTbDeleteItemsAction(), "Delete selected items");
        this.tbCopyItems = new ToolbarButton(new ImageIcon(Utils.getImage("copy.png")), this.createTbCopyItemsAction(), "Copy selected items to group");
        this.tbMoveUp = new ToolbarButton(new ImageIcon(Utils.getImage("up.png")), this.createTbMoveUpAction(), "Move selected item up");
        this.tbMoveDown = new ToolbarButton(new ImageIcon(Utils.getImage("down.png")), this.createTbMoveDownAction(), "Move selected item down");
        this.tbSearch = new ToolbarButton(new ImageIcon(Utils.getImage("find.png")), this.createTbSearchAction(), "Search");
        GuiUtils.setSize(this.tbMoveUp, new Dimension(20, 25));
        GuiUtils.setSize(this.tbMoveDown, new Dimension(20, 25));
    }

    private Action createTbNewItemAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().createNewItem();
            }
        };
    }

    private Action createTbOpenItemAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().openSelectedItem();
            }
        };
    }

    private Action createTbDeleteItemsAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().deleteSelectedItems();
            }
        };
    }

    private Action createTbCopyItemsAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().copySelectedItemsToGroup();
            }
        };
    }

    private Action createTbSearchAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().showSearchPane();
            }
        };
    }

    private Action createTbMoveDownAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().moveSelectedItemDown();
            }
        };
    }

    private Action createTbMoveUpAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.getInstance().moveSelectedItemUp();
            }
        };
    }

    public Component getToolbarPanel() {
        return this.toolbarPanel;
    }

    public ToolbarButton getTbNewItem() {
        return this.tbNewItem;
    }

    public ToolbarButton getTbOpenItem() {
        return this.tbOpenItem;
    }

    public ToolbarButton getTbDeleteItems() {
        return this.tbDeleteItems;
    }

    public ToolbarButton getTbCopyItems() {
        return this.tbCopyItems;
    }

    public ToolbarButton getTbMoveUp() {
        return this.tbMoveUp;
    }

    public ToolbarButton getTbMoveDown() {
        return this.tbMoveDown;
    }

    public ToolbarButton getTbSearch() {
        return this.tbSearch;
    }
}

