/*
 * Decompiled with CFR 0.152.
 */
package kb.gui.toolbar;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import kb.gui.toolbar.ToolbarButton;

public class ToolbarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<List<ToolbarButton>> groups = new ArrayList<List<ToolbarButton>>();

    public ToolbarPanel() {
        this.setLayout(new GridBagLayout());
    }

    public void addToolbarButtonsGroup(List<ToolbarButton> buttons) {
        this.groups.add(buttons);
    }

    public void build() {
        int x = 0;
        for (List<ToolbarButton> group : this.groups) {
            if (x != 0) {
                this.addSeparator(x++);
            }
            this.addToolbarButtonGroup(group, x);
            x += group.size();
        }
        this.addEmptyLabel(x);
    }

    private void addEmptyLabel(int x) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)new JLabel(), c);
    }

    private void addSeparator(int x) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = 0;
        c.insets = new Insets(2, 0, 2, 0);
        c.fill = 3;
        this.add((Component)new JSeparator(1), c);
    }

    private void addToolbarButtonGroup(List<ToolbarButton> buttons, int x) {
        for (ToolbarButton button : buttons) {
            this.addToolbarButton(button, x++);
        }
    }

    private void addToolbarButton(ToolbarButton button, int x) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = 0;
        c.anchor = 17;
        this.add((Component)button, c);
    }
}

